<?php
namespace Mainto\Bridge\Invokes\TrainingProject\User\DingTalk;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addNoteByParams(array $params)
 * @method editNoteByParams(array $params)
 * @method deleteNoteByParams(array $params)
 * @method getNoteDetailByParams(array $params)
 * @method getNoteListByParams(array $params)
 */
class Note {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新增笔记
     *
     * @support  int $courseId 课程id require false
     * @param  string $title 标题 [ require true ]
     * @param  string $content 内容 [ require true ]
     * @param  string $experience 感想 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addNote (string $title, string $content, string $experience = '') {
        return self::getClass()->addNote([
            "title" => $title,
            "content" => $content,
            "experience" => $experience,
        ]);
    }

    /**
     * 编辑笔记
     *
     * @param  int $id 笔记id [ require true ]
     * @param  string $title 标题 [ require true ]
     * @param  string $content 内容 [ require true ]
     * @param  string $experience 感想 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editNote (int $id, string $title, string $content, string $experience = '') {
        return self::getClass()->editNote([
            "id" => $id,
            "title" => $title,
            "content" => $content,
            "experience" => $experience,
        ]);
    }

    /**
     * 删除笔记
     *
     * @param  int $id 笔记id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteNote (int $id) {
        return self::getClass()->deleteNote([
            "id" => $id,
        ]);
    }

    /**
     * 获取笔记详情
     *
     * @param  int $id 笔记id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getNoteDetail (int $id) {
        return self::getClass()->getNoteDetail([
            "id" => $id,
        ]);
    }

    /**
     * 获取笔记列表
     *
     * @param  string $keyword 搜索关键词 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页记录数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getNoteList (int $page = 1, int $pageSize = 10, string $keyword = '') {
        return self::getClass()->getNoteList([
            "page" => $page,
            "pageSize" => $pageSize,
            "keyword" => $keyword,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'User\DingTalk\Note');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'User\DingTalk\Note');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}