<?php
namespace Mainto\Bridge\Invokes\TrainingProject\User\DingTalk;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAppraiseStandardByParams(array $params)
 * @method getDetailByParams(array $params)
 * @method addCourseAppraiseByParams(array $params)
 */
class Appraise {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取评价标准
     *
     * @param  int $courseId 课程id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAppraiseStandard (int $courseId) {
        return self::getClass()->getAppraiseStandard([
            "courseId" => $courseId,
        ]);
    }

    /**
     * 获取评价详情
     *
     * @param  int $courseId 课程 id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getDetail (int $courseId) {
        return self::getClass()->getDetail([
            "courseId" => $courseId,
        ]);
    }

    /**
     * 新增评价
     *
     * @param  int $courseId 课程id [ require true ]
     * @param  int $star 星数 [ require true ]
     * @param  array $tags 标签内容 [ require true ]
     * @support  string $comment 标签内容 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function addCourseAppraise (int $courseId, int $star, array $tags) {
        return self::getClass()->addCourseAppraise([
            "courseId" => $courseId,
            "star" => $star,
            "tags" => $tags,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'User\DingTalk\Appraise');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'User\DingTalk\Appraise');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}