<?php
namespace Mainto\Bridge\Invokes\TrainingProject\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPracticeListByParams(array $params)
 * @method getAssessmentListByParams(array $params)
 * @method getPracticeKnowledgeListByParams(array $params)
 * @method getAssessmentKnowledgeListByParams(array $params)
 * @method getExaminationRecordByParams(array $params)
 * @method passByParams(array $params)
 * @method rejectByParams(array $params)
 * @method waitAnswerNotifyByParams(array $params)
 * @method sendWaitAnswerNotifyBatchByParams(array $params)
 */
class ExaminationRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 分页获取练习记录列表.修片
     *
     * @param  int $taskId 任务id [ require true ]
     * @support  string $name 员工姓名 require false
     * @support  array $status 状态 require false
     * @support  string $submitAtBegin 提交时间开始 require false
     * @support  string $submitAtEnd 提交时间结束 require false
     * @support  array $departmentIds 部门ids require false
     * @param  int $page page [ require true ]
     * @param  int $pageSize page_size [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPracticeList (int $taskId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getPracticeList([
            "taskId" => $taskId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 分页获取考核记录列表.修片
     *
     * @param  int $taskId 任务id [ require true ]
     * @support  string $name 员工姓名 require false
     * @support  array $status 状态 require false
     * @support  string $submitAtBegin 提交时间开始 require false
     * @support  string $submitAtEnd 提交时间结束 require false
     * @support  array $departmentIds 部门ids require false
     * @param  int $page page [ require true ]
     * @param  int $pageSize page_size [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAssessmentList (int $taskId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getAssessmentList([
            "taskId" => $taskId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 分页获取练习记录列表.知识问答
     *
     * @param  int $taskId 任务id [ require true ]
     * @support  string $name 员工姓名 require false
     * @support  string $submitAtBegin 提交时间开始 require false
     * @support  string $submitAtEnd 提交时间结束 require false
     * @support  array $departmentIds 部门ids require false
     * @param  int $page page [ require true ]
     * @param  int $pageSize page_size [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPracticeKnowledgeList (int $taskId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getPracticeKnowledgeList([
            "taskId" => $taskId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 分页获取考核记录列表.知识问答
     *
     * @param  int $taskId 任务id [ require true ]
     * @support  string $name 员工姓名 require false
     * @support  array $status 状态，两种状态 已评分 [pass, reject], 未提交 [wait_answer, answering] require false
     * @support  string $submitAtBegin 提交时间开始 require false
     * @support  string $submitAtEnd 提交时间结束 require false
     * @support  array $departmentIds 部门ids require false
     * @param  int $page page [ require true ]
     * @param  int $pageSize page_size [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAssessmentKnowledgeList (int $taskId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getAssessmentKnowledgeList([
            "taskId" => $taskId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取练习考核记录详情
     *
     * @param  int $recordId 记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getExaminationRecord (int $recordId) {
        return self::getClass()->getExaminationRecord([
            "recordId" => $recordId,
        ]);
    }

    /**
     * 评分通过
     *
     * @param  int $recordId 记录id [ require true ]
     * @param  array $reviewItem 评分详情 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function pass (int $recordId, array $reviewItem) {
        return self::getClass()->pass([
            "recordId" => $recordId,
            "reviewItem" => $reviewItem,
        ]);
    }

    /**
     * 评分退回
     *
     * @param  int $recordId 记录id [ require true ]
     * @param  array $reviewItem 评分详情 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reject (int $recordId, array $reviewItem) {
        return self::getClass()->reject([
            "recordId" => $recordId,
            "reviewItem" => $reviewItem,
        ]);
    }

    /**
     * 提醒答题通知
     *
     * @param  int $staffId 工号 [ require true ]
     * @param  string $contentType 内容类型，修片 retouch，知识问答 knowledge [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function waitAnswerNotify (int $staffId, string $contentType) {
        return self::getClass()->waitAnswerNotify([
            "staffId" => $staffId,
            "contentType" => $contentType,
        ]);
    }

    /**
     * 提醒答题通知.一键提醒批量
     *
     * @param  int $taskId 任务id [ require true ]
     * @support  string $name 员工姓名 require false
     * @support  string $submitAtBegin 提交时间开始 require false
     * @support  string $submitAtEnd 提交时间结束 require false
     * @support  array $departmentIds 部门ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendWaitAnswerNotifyBatch (int $taskId) {
        return self::getClass()->sendWaitAnswerNotifyBatch([
            "taskId" => $taskId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'Manage\ExaminationRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'Manage\ExaminationRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}