<?php
namespace Mainto\Bridge\Invokes\TrainingProject\User\DingTalk;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method beginExamByParams(array $params)
 * @method getExaminationRecordByParams(array $params)
 * @method refreshByParams(array $params)
 * @method submitByParams(array $params)
 * @method exitExamByParams(array $params)
 */
class ExaminationKnowledge {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 开始练习/考核
     *
     * @param  int $taskId 任务id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function beginExam (int $taskId) {
        return self::getClass()->beginExam([
            "taskId" => $taskId,
        ]);
    }

    /**
     * 获取题目
     *
     * @param  int $recordId 记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getExaminationRecord (int $recordId) {
        return self::getClass()->getExaminationRecord([
            "recordId" => $recordId,
        ]);
    }

    /**
     * 刷新题目
     *
     * @param  int $recordId 记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function refresh (int $recordId) {
        return self::getClass()->refresh([
            "recordId" => $recordId,
        ]);
    }

    /**
     * 提交练习/考核数据
     *
     * @param  int $recordId 记录id [ require true ]
     * @param  array $submitItem 评分详情 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submit (int $recordId, array $submitItem) {
        return self::getClass()->submit([
            "recordId" => $recordId,
            "submitItem" => $submitItem,
        ]);
    }

    /**
     * 退出练习/考核
     *
     * @param  int $recordId 记录id [ require true ]
     * @param  array $submitItem 评分详情 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function exitExam (int $recordId, array $submitItem) {
        return self::getClass()->exitExam([
            "recordId" => $recordId,
            "submitItem" => $submitItem,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'User\DingTalk\ExaminationKnowledge');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'User\DingTalk\ExaminationKnowledge');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}