<?php
namespace Mainto\Bridge\Invokes\TrainingProject\Manage\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStaffsByParams(array $params)
 */
class Staff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 伙伴信息查询.按条件
     *
     * @support  array $staffIds 工号ids require false
     * @support  array $deptIds 部门ids require false
     * @support  array $positionIds 职位ids require false
     * @param  bool $withDelete 包含离职 [ require true ]
     * @support  bool $onlyDelete 只要离职 require false
     * @support  string $keyword 工号|花名|姓名 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffs (bool $withDelete = false) {
        return self::getClass()->getStaffs([
            "withDelete" => $withDelete,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'Manage\Staff\Staff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'Manage\Staff\Staff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}