<?php
namespace Mainto\Bridge\Invokes\TrainingProject\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAppraiseListByParams(array $params)
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 * @method deleteByParams(array $params)
 */
class CourseAppraise {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 评价列表
     *
     * @support  string $searchName 搜索名称 require false
     * @support  array $stars 星数（如：[3,4,5]） require false
     * @support  int $categoryId 课程分类ID require false
     * @support  int $teacherId 讲师ID require false
     * @support  array $departmentIds 部门ids [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页记录数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAppraiseList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getAppraiseList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 新增导出任务
     *
     * @support  string $templateId 模板id= training_project_course_appraise_template require false
     * @support  array $params 参数 [&#039;searchName&#039;=&gt;&#039;搜索的课程名称&#039;,&#039;stars&#039;=&gt;&#039;星数 [3,4,5]&#039;,&#039;teacherId&#039;=&gt;&#039;教师 id&#039;,&#039;categoryId&#039;=&gt;&#039;分类 id&#039;,] require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 获取导出任务列表
     *
     * @support  string $templateId 导出模板id require false
     * @support  int $page 页码 require false
     * @support  int $pageSize 每页数量 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 删除导出任务
     *
     * @support  array $taskIds 任务ids require false
     * @support  array $templateIds 模板ids require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete () {
        return self::getClass()->delete();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'Manage\CourseAppraise');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'Manage\CourseAppraise');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}