<?php
namespace Mainto\Bridge\Invokes\TrainingProject\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method checkCourseNameActiveByParams(array $params)
 * @method getCourseListByParams(array $params)
 * @method getAllCourseNamesByParams(array $params)
 * @method addCourseByParams(array $params)
 * @method editCourseByParams(array $params)
 * @method getCourseByIdByParams(array $params)
 * @method deleteCourseByParams(array $params)
 * @method onlineCourseByParams(array $params)
 * @method getGroupIdsByIdByParams(array $params)
 * @method getStaffStudyListByParams(array $params)
 * @method addRemindByParams(array $params)
 * @method getCourseScheduleListByStaffIdAndStudyStatusByParams(array $params)
 * @method getCourseListByCourseIdsAndStudyTypeAndNameByParams(array $params)
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 * @method deleteByParams(array $params)
 */
class Course {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 课程.检测课程名称可用
     *
     * @param  string $name 课程名称 [ require true ]
     * @param  string $studyType 学习类型，compulsory，not_compulsory [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkCourseNameActive (string $name, string $studyType = '') {
        return self::getClass()->checkCourseNameActive([
            "name" => $name,
            "studyType" => $studyType,
        ]);
    }

    /**
     * 课程.列表分页
     *
     * @support  string $name 名称 
     * @support  array $courseIds 课程id数组 
     * @support  string $studyType 学习类型，compulsory，not_compulsory 
     * @support  int $categoryId 课程分类id 
     * @support  string $status 状态，online,offline 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCourseList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getCourseList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 课程.所有.名称
     *
     * @support  string $name 名称 
     * @throws  \Exception
     * @return  array
     */
    public static function getAllCourseNames () {
        return self::getClass()->getAllCourseNames();
    }

    /**
     * 课程.新增
     *
     * @support  string $name 名称 [ require true ]
     * @support  string $description 课程简介 
     * @support  string $studyType 学习类型，compulsory，not_compulsory [ require true ]
     * @support  int $categoryId 课程分类id [ require true ]
     * @support  int $teacherId 讲师id [ require true ]
     * @support  string $coverPicture 封面图地址 [ require true ]
     * @support  int $appraiseStandardId 评价标准id [ require true ]
     * @support  string $type 课件资料类型，normal,video,audio [ require true ]
     * @support  array $metaInfo 学习资料，视频，音频数据 
     * @support  int $questionBankId 小节题关联题库id 
     * @support  string $document 文档内容 
     * @support  bool $isWatermark 是否打水印 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addCourse () {
        return self::getClass()->addCourse();
    }

    /**
     * 课程.编辑
     *
     * @support  int $id id [Original type uint] [ require true ]
     * @support  string $name 名称 [ require true ]
     * @support  string $description 课程简介 
     * @support  int $categoryId 课程分类id [ require true ]
     * @support  int $teacherId 讲师id [ require true ]
     * @support  string $coverPicture 封面图地址 [ require true ]
     * @support  int $appraiseStandardId 评价标准id [ require true ]
     * @support  string $type 课件资料类型，normal,video,audio [ require true ]
     * @support  array $metaInfo 学习资料 
     * @support  int $questionBankId 小节题关联题库id 
     * @support  string $document 文档内容 
     * @support  bool $isWatermark 是否打水印 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editCourse () {
        return self::getClass()->editCourse();
    }

    /**
     * 课程.单个详情
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCourseById (int $id) {
        return self::getClass()->getCourseById([
            "id" => $id,
        ]);
    }

    /**
     * 课程.删除
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteCourse (int $id) {
        return self::getClass()->deleteCourse([
            "id" => $id,
        ]);
    }

    /**
     * 课程.上下线
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @param  string $status 状态，offline, online [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function onlineCourse (int $id, string $status) {
        return self::getClass()->onlineCourse([
            "id" => $id,
            "status" => $status,
        ]);
    }

    /**
     * 课程.获得groupIds
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getGroupIdsById (int $id) {
        return self::getClass()->getGroupIdsById([
            "id" => $id,
        ]);
    }

    /**
     * 课程.学习明细.个人数据列表分页
     *
     * @support  array $deptIds 部门ids [Original type array&lt;uint&gt;] [ require true ]
     * @support  int $groupId 用户组id 
     * @support  int $staffId 伙伴工号 
     * @support  array $positionIds 职位ids [Original type array&lt;uint&gt;] 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffStudyList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getStaffStudyList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 课程.学习明细.提醒
     *
     * @param  int $staffId 工号 [ require true ]
     * @param  string $msg 消息内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addRemind (int $staffId, string $msg) {
        return self::getClass()->addRemind([
            "staffId" => $staffId,
            "msg" => $msg,
        ]);
    }

    /**
     * 课程.学习明细.个人详情
     *
     * @param  int $staffId 工号 [ require true ]
     * @param  string $studyStatus 学习状态，已完成 complete；未完成 completing [ require true ]
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCourseScheduleListByStaffIdAndStudyStatus (int $staffId, string $studyStatus = NULL, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getCourseScheduleListByStaffIdAndStudyStatus([
            "staffId" => $staffId,
            "studyStatus" => $studyStatus,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 课程.学习明细.课程数据列表分页
     *
     * @support  array $courseIds 课程id数组 
     * @support  string $studyType 学习类型，compulsory，not_compulsory 
     * @support  string $name 课程名称 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCourseListByCourseIdsAndStudyTypeAndName (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getCourseListByCourseIdsAndStudyTypeAndName([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 课程.学习明细.下载.新增导出任务
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数, 个人数据 [deptIds:1,groupId:1,staff:test,positionIds:[1,2,3]]；课程数据 [courseId:1] 
     * @throws  \Exception
     * @return  string
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 课程.学习明细.下载.获取列表分页
     *
     * @support  string $template_id 导出模板id 
     * @support  int $page 页码 
     * @support  int $page_size 每页数量 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 课程.学习明细.下载.删除记录
     *
     * @support  array $task_ids 任务ids [Original type array&lt;string&gt;] 
     * @support  array $template_ids 模板ids [Original type array&lt;string&gt;] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete () {
        return self::getClass()->delete();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'Manage\Course');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'Manage\Course');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}