<?php
namespace Mainto\Bridge\Invokes\TrainingProject\Manage\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStaffManageListByParams(array $params)
 * @method getProductCatAllByParams(array $params)
 * @method syncProductCatByParams(array $params)
 * @method onProductCatEmptyByParams(array $params)
 * @method getProductCatByParams(array $params)
 * @method onStaffPluralismConfirmByParams(array $params)
 */
class StaffProductCat {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 技术通关管理列表查询
     *
     * @param  array $deptIds 部门或门店id数组集合 [Original type array&lt;uint&gt;] [ require true ]
     * @support  string $staff 姓名或工号 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffManageList (array $deptIds = [], int $page = 1, int $pageSize = 10) {
        return self::getClass()->getStaffManageList([
            "deptIds" => $deptIds,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 通关品类.产品树
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductCatAll () {
        return self::getClass()->getProductCatAll();
    }

    /**
     * 通关品类.产品保存
     *
     * @param  array $productIds 产品ids [Original type array&lt;uint&gt;] [ require true ]
     * @param  int $staffId staffId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncProductCat (int $staffId, array $productIds = []) {
        return self::getClass()->syncProductCat([
            "staffId" => $staffId,
            "productIds" => $productIds,
        ]);
    }

    /**
     * onProductCatEmpty
     *
     * @param  int $staff_id 伙伴id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function onProductCatEmpty (int $staff_id) {
        return self::getClass()->onProductCatEmpty([
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * 通关品类.产品列表
     *
     * @param  int $staffId staffId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductCat (int $staffId) {
        return self::getClass()->getProductCat([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 兼岗事件处理
     *
     * @param  int $staff_id staffId [Original type uint] [ require true ]
     * @support  int $job_id staffId [Original type uint] [ require true ]
     * @support  int $pluralism_store_id staffId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function onStaffPluralismConfirm (int $staff_id) {
        return self::getClass()->onStaffPluralismConfirm([
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'Manage\Staff\StaffProductCat');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'Manage\Staff\StaffProductCat');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}