<?php
namespace Mainto\Bridge\Invokes\TrainingProject\Manage\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getServiceListByParams(array $params)
 * @method syncServicePassByParams(array $params)
 * @method exportByParams(array $params)
 * @method getPermissionStoresByParams(array $params)
 * @method onStaffCreatedByParams(array $params)
 */
class StaffService {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 服务通关管理列表查询
     *
     * @param  array $deptIds 部门或门店id数组集合 [Original type array&lt;uint&gt;] [ require true ]
     * @support  string $staff 姓名或工号 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getServiceList (array $deptIds = [], int $page = 1, int $pageSize = 10) {
        return self::getClass()->getServiceList([
            "deptIds" => $deptIds,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 服务通关保存
     *
     * @param  int $staffId staffId [Original type uint] [ require true ]
     * @param  bool $isPass 是否通关 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncServicePass (int $staffId, bool $isPass = false) {
        return self::getClass()->syncServicePass([
            "staffId" => $staffId,
            "isPass" => $isPass,
        ]);
    }

    /**
     * 服务通关管理导出
     *
     * @param  array $deptIds 部门或门店id数组集合 [Original type array&lt;uint&gt;] [ require true ]
     * @support  string $staff 姓名或工号 
     * @throws  \Exception
     * @return  mixed
     */
    public static function export (array $deptIds = []) {
        return self::getClass()->export([
            "deptIds" => $deptIds,
        ]);
    }

    /**
     * 获取管辖门店范围
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getPermissionStores () {
        return self::getClass()->getPermissionStores();
    }

    /**
     * onStaffCreated
     *
     * @param  int $staff_id 伙伴id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function onStaffCreated (int $staff_id) {
        return self::getClass()->onStaffCreated([
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'Manage\Staff\StaffService');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'Manage\Staff\StaffService');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}