<?php
namespace Mainto\Bridge\Invokes\TrainingProject\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAllListByParams(array $params)
 * @method getListWithCourseNumByParams(array $params)
 * @method getCategoryIdsAndCourseIdsByParams(array $params)
 * @method getAllListInGroupsByParams(array $params)
 * @method getAllListInGroupsWithCompulsoryByParams(array $params)
 */
class Category {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取所有匹配的分类列表（不分页）
     *
     * @support  string $type 类型 
     * @throws  \Exception
     * @return  array
     */
    public static function getAllList () {
        return self::getClass()->getAllList();
    }

    /**
     * 获取分类及分类下的课程数
     *
     * @param  string $categoryType 课程类型 [ require true ]
     * @support  array $categoryIds 课程分类id数组 [Original type array&lt;uint&gt;] 
     * @throws  \Exception
     * @return  array
     */
    public static function getListWithCourseNum (string $categoryType) {
        return self::getClass()->getListWithCourseNum([
            "categoryType" => $categoryType,
        ]);
    }

    /**
     * 获取所有有课程的分类id及所有课程id
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getCategoryIdsAndCourseIds () {
        return self::getClass()->getCategoryIdsAndCourseIds();
    }

    /**
     * 获取分类列表区分用户（不分页，课程，案例）
     *
     * @support  string $type 类型 
     * @throws  \Exception
     * @return  array
     */
    public static function getAllListInGroups () {
        return self::getClass()->getAllListInGroups();
    }

    /**
     * 获取所有课程分类数据区分用户（必修，选修）
     *
     * @support  string $studyType 类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAllListInGroupsWithCompulsory () {
        return self::getClass()->getAllListInGroupsWithCompulsory();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'User\Category');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'User\Category');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}