<?php
namespace Mainto\Bridge\Invokes\TrainingProject\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getRecordListAndStatsByParams(array $params)
 * @method savePositionUsedGlobalByParams(array $params)
 * @method getPositionUsedGlobalByParams(array $params)
 */
class Statistics {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取练习记录和统计数据
     *
     * @support  array $taskIds 任务id数组 [Original type array&lt;uint&gt;] [ require true ]
     * @support  string $scoreBeginTime 评分开始时间 
     * @support  string $scoreEndTime 评分结束时间 
     * @support  string $submitBeginTime 提交开始时间 
     * @support  string $submitEndTime 提交结束时间 
     * @support  string $staffId 员工工号 
     * @support  int $groupId 用户组id [Original type uint] 
     * @support  array $departmentIds 部门ids [Original type array&lt;uint&gt;] [ require true ]
     * @support  bool $isOvertime 是否超时 
     * @support  bool $isPass 是否通过 
     * @support  array $positionIds 职位ids [Original type array&lt;uint&gt;] 
     * @support  string $type 查询类型，assessment 为考核，practice 为练习 
     * @param  int $page page [Original type uint] [ require true ]
     * @param  int $pageSize page_size [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRecordListAndStats (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getRecordListAndStats([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 储存常用的职位集合
     *
     * @param  array $positionIds 职位ids [Original type array&lt;uint&gt;] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function savePositionUsedGlobal (array $positionIds) {
        return self::getClass()->savePositionUsedGlobal([
            "positionIds" => $positionIds,
        ]);
    }

    /**
     * 获得常用的职位集合
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getPositionUsedGlobal () {
        return self::getClass()->getPositionUsedGlobal();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'Manage\Statistics');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'Manage\Statistics');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}