<?php
namespace Mainto\Bridge\Invokes\TrainingProject\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method deleteByParams(array $params)
 * @method getCommentListByParams(array $params)
 * @method getAllReplyByParams(array $params)
 * @method topByParams(array $params)
 * @method unTopByParams(array $params)
 * @method rewardCreditByParams(array $params)
 * @method replyByParams(array $params)
 */
class Comment {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 删除留言/回复
     *
     * @param  int $id 留言/回复 id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 留言列表
     *
     * @support  string $searchName 搜索名称 
     * @support  int $categoryId 课程分类ID 
     * @support  string $type 类型:课程/案例（英文） 
     * @support  int $isTop 是否置顶（1:置顶） [Original type uint] 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCommentList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getCommentList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 回复列表
     *
     * @param  int $topCommentId 留言的 id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllReply (int $topCommentId) {
        return self::getClass()->getAllReply([
            "topCommentId" => $topCommentId,
        ]);
    }

    /**
     * 置顶
     *
     * @param  int $commentId 留言id [ require true ]
     * @param  int $relationId 关联id:课程/案例 [Original type uint] [ require true ]
     * @param  string $type 类型:课程/案例（英文） [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function top (int $commentId, int $relationId, string $type) {
        return self::getClass()->top([
            "commentId" => $commentId,
            "relationId" => $relationId,
            "type" => $type,
        ]);
    }

    /**
     * 取消置顶
     *
     * @param  int $id 留言id [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function unTop (int $id) {
        return self::getClass()->unTop([
            "id" => $id,
        ]);
    }

    /**
     * 打赏积分
     *
     * @param  int $toStaffId 给分的对象id [ require true ]
     * @param  int $points 积分点数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function rewardCredit (int $toStaffId, int $points) {
        return self::getClass()->rewardCredit([
            "toStaffId" => $toStaffId,
            "points" => $points,
        ]);
    }

    /**
     * 回复留言
     *
     * @support  int $relationId 关联id:课程/案例 [Original type uint] [ require true ]
     * @support  string $type 类型:课程/案例（英文） [ require true ]
     * @support  int $topCommentId 留言的 id [Original type uint] [ require true ]
     * @support  int $parentId 被回复的信息id [Original type uint] [ require true ]
     * @support  int $toStaffId 被回复的伙伴工号id [Original type uint] [ require true ]
     * @support  string $comment 回复内容（限制 255字以内） [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reply () {
        return self::getClass()->reply();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'Manage\Comment');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'Manage\Comment');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}