<?php
namespace Mainto\Bridge\Invokes\TrainingProject\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getListByPageByParams(array $params)
 * @method addCaseByParams(array $params)
 * @method editCaseByParams(array $params)
 * @method getCaseByIdByParams(array $params)
 * @method deleteCaseByParams(array $params)
 * @method onlineCaseByParams(array $params)
 * @method getCaseListWithReadByPageByParams(array $params)
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 * @method deleteByParams(array $params)
 */
class Case {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 案例.列表分页
     *
     * @support  int $categoryId 案例分类id [Original type uint] 
     * @support  string $title 标题 
     * @support  string $publishBeginDate 发布开始日期 
     * @support  string $publishEndDate 发布结束日期 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListByPage (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getListByPage([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 案例.新增
     *
     * @support  string $title 标题 [ require true ]
     * @support  int $categoryId 案例分类id [Original type uint] [ require true ]
     * @support  string $source 来源 [ require true ]
     * @support  string $coverPicture 封面图地址 [ require true ]
     * @support  string $description 描述 
     * @support  array $groupIds 用户组数组 [ require true ]
     * @support  string $status 状态，offline, online 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addCase () {
        return self::getClass()->addCase();
    }

    /**
     * 案例.编辑
     *
     * @support  int $id id [Original type uint] [ require true ]
     * @support  string $title 标题 [ require true ]
     * @support  int $categoryId 案例分类id [Original type uint] [ require true ]
     * @support  string $source 来源 
     * @support  string $coverPicture 封面图地址 [ require true ]
     * @support  string $description 描述 
     * @support  array $groupIds 用户组数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editCase () {
        return self::getClass()->editCase();
    }

    /**
     * 案例.单个详情
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCaseById (int $id) {
        return self::getClass()->getCaseById([
            "id" => $id,
        ]);
    }

    /**
     * 案例.删除
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteCase (int $id) {
        return self::getClass()->deleteCase([
            "id" => $id,
        ]);
    }

    /**
     * 案例.上下线
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @param  string $status 状态，offline, online [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function onlineCase (int $id, string $status) {
        return self::getClass()->onlineCase([
            "id" => $id,
            "status" => $status,
        ]);
    }

    /**
     * 案例.学习明细.列表分页
     *
     * @param  string $title 标题 [ require true ]
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCaseListWithReadByPage (string $title = '', int $page = 1, int $pageSize = 10) {
        return self::getClass()->getCaseListWithReadByPage([
            "title" => $title,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 案例.学习明细.下载.新增导出任务
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数, [caseId:1] 
     * @throws  \Exception
     * @return  string
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 案例.学习明细.下载.获取列表分页
     *
     * @support  string $template_id 导出模板id 
     * @support  int $page 页码 
     * @support  int $page_size 每页数量 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 案例.学习明细.下载.删除记录
     *
     * @support  array $task_ids 任务ids [Original type array&lt;string&gt;] 
     * @support  array $template_ids 模板ids [Original type array&lt;string&gt;] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete () {
        return self::getClass()->delete();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'Manage\Case');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'Manage\Case');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}