<?php
namespace Mainto\Bridge\Invokes\TrainingProject\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getListByPageByParams(array $params)
 * @method addCoursePlanGroupsByParams(array $params)
 * @method editCoursePlanGroupsByParams(array $params)
 * @method saveCoursePlanScheduleByParams(array $params)
 */
class CoursePlan {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * RpcAuthority(need=&quot;manage.230.task.manage.edit&quot;)
     *
     * @support  string $name 学习计划名称 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListByPage (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getListByPage([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * RpcAuthority(need=&quot;manage.230.task.manage.edit&quot;)
     *
     * @support  string $name 学习计划名称 [ require true ]
     * @support  array $groupIds 用户组 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addCoursePlanGroups () {
        return self::getClass()->addCoursePlanGroups();
    }

    /**
     * RpcAuthority(need=&quot;manage.230.task.manage.edit&quot;)
     *
     * @support  int $id 计划id [Original type uint] [ require true ]
     * @support  string $name 学习计划名称 [ require true ]
     * @support  array $groupIds 用户组 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editCoursePlanGroups () {
        return self::getClass()->editCoursePlanGroups();
    }

    /**
     * RpcAuthority(need=&quot;manage.230.task.manage.edit&quot;)
     *
     * @support  int $id 计划id [Original type uint] [ require true ]
     * @support  array $schedules 学习计划组集合 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveCoursePlanSchedule () {
        return self::getClass()->saveCoursePlanSchedule();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'Manage\CoursePlan');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'Manage\CoursePlan');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}