<?php
namespace Mainto\Bridge\Invokes\TrainingProject\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getListByPageByParams(array $params)
 * @method addAppraiseStandardsByParams(array $params)
 * @method editAppraiseStandardsByParams(array $params)
 * @method getAppraiseStandardByIdByParams(array $params)
 * @method deleteAppraiseStandardsByParams(array $params)
 * @method getAllByParams(array $params)
 */
class AppraiseStandard {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * RpcAuthority(need=&quot;manage.230.task.manage.edit&quot;)
     *
     * @param  string $name 名称 [ require true ]
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListByPage (string $name = '', int $page = 1, int $pageSize = 10) {
        return self::getClass()->getListByPage([
            "name" => $name,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * RpcAuthority(need=&quot;manage.230.task.manage.edit&quot;)
     *
     * @param  string $name 名称 [ require true ]
     * @param  array $info 评价标准 [star: 1, tags: [标签内容]}] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addAppraiseStandards (string $name, array $info) {
        return self::getClass()->addAppraiseStandards([
            "name" => $name,
            "info" => $info,
        ]);
    }

    /**
     * RpcAuthority(need=&quot;manage.230.task.manage.edit&quot;)
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @param  string $name 名称 [ require true ]
     * @param  array $info 评价标准 [{star: 1, tags: [标签内容]}] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editAppraiseStandards (int $id, string $name, array $info) {
        return self::getClass()->editAppraiseStandards([
            "id" => $id,
            "name" => $name,
            "info" => $info,
        ]);
    }

    /**
     * RpcAuthority(need=&quot;manage.230.task.manage.edit&quot;)
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAppraiseStandardById (int $id) {
        return self::getClass()->getAppraiseStandardById([
            "id" => $id,
        ]);
    }

    /**
     * RpcAuthority(need=&quot;manage.230.task.manage.edit&quot;)
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteAppraiseStandards (int $id) {
        return self::getClass()->deleteAppraiseStandards([
            "id" => $id,
        ]);
    }

    /**
     * RpcAuthority(need=&quot;manage.230.task.manage.edit&quot;)
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getAll () {
        return self::getClass()->getAll();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'Manage\AppraiseStandard');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'Manage\AppraiseStandard');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}