<?php
namespace Mainto\Bridge\Invokes\TrainingProject\User\DingTalk;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method loginDetailByParams(array $params)
 * @method dynamicByParams(array $params)
 * @method exchangeWishValueByParams(array $params)
 * @method getChangeLogListByParams(array $params)
 * @method getCreditTypeByParams(array $params)
 * @method getTopByParams(array $params)
 */
class Staff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取用户信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function loginDetail () {
        return self::getClass()->loginDetail();
    }

    /**
     * 获取学习动态
     *
     * @support  string $dateStart 日期起 [ require true ]
     * @support  string $dateEnd 日期止 [ require true ]
     * @support  string $itemName 统计项 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function dynamic () {
        return self::getClass()->dynamic();
    }

    /**
     * 兑换愿望值
     *
     * @param  int $wishValue 愿望值 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function exchangeWishValue (int $wishValue) {
        return self::getClass()->exchangeWishValue([
            "wishValue" => $wishValue,
        ]);
    }

    /**
     * 获取积分变更事件
     *
     * @param  int $page page [Original type uint] [ require true ]
     * @param  int $pageSize page_size [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getChangeLogList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getChangeLogList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取积分类型
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getCreditType () {
        return self::getClass()->getCreditType();
    }

    /**
     * 获得排行信息
     *
     * @param  string $itemName 排行项 [ require true ]
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 页码 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTop (string $itemName, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getTop([
            "itemName" => $itemName,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'User\DingTalk\Staff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'User\DingTalk\Staff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}