<?php
namespace Mainto\Bridge\Invokes\TrainingProject\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCompulsoryListByPageByParams(array $params)
 * @method getListByPageWithStatusByParams(array $params)
 */
class Course {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 课程（必修，选修，最新）.列表
     *
     * @support  string $name 课程名称 
     * @support  int $categoryId 课程分类id [Original type uint] 
     * @support  string $studyType 课程类型，选修 not_compulsory，必修 compulsory 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCompulsoryListByPage (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getCompulsoryListByPage([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 课程（进行中，待学习）.列表
     *
     * @support  string $name 课程名称 
     * @support  int $categoryId 课程分类id [Original type uint] 
     * @support  string $studyType 课程类型，选修 not_compulsory，必修 compulsory 
     * @support  string $scheduleStatus 课程记录状态，learning 进行中；不传为未学习 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListByPageWithStatus (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getListByPageWithStatus([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'User\Course');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'User\Course');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}