<?php
namespace Mainto\Bridge\Invokes\TrainingProject\Manage\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStaffGroupListByParams(array $params)
 * @method createStaffGroupByParams(array $params)
 * @method editStaffGroupByParams(array $params)
 * @method deleteStaffGroupByParams(array $params)
 * @method getGroupsByParams(array $params)
 * @method getGroupByParams(array $params)
 * @method getStaffIdsByGroupRulesByParams(array $params)
 * @method getStaffsByStaffIdsByParams(array $params)
 */
class StaffGroup {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用户组列表查询
     *
     * @param  string $groupName 用户组名称 [ require true ]
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @param  bool $withStaffIds 附加staff ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffGroupList (int $page, int $pageSize, string $groupName = '', bool $withStaffIds = false) {
        return self::getClass()->getStaffGroupList([
            "page" => $page,
            "pageSize" => $pageSize,
            "groupName" => $groupName,
            "withStaffIds" => $withStaffIds,
        ]);
    }

    /**
     * 用户组新增
     *
     * @param  string $groupName 用户组名称 [ require true ]
     * @param  array $rules 规则组[[&#039;department_id&#039; =&gt; &#039;&#039;, &#039;job_id&#039; =&gt; &#039;&#039;, &#039;level&#039; =&gt; &#039;&#039;]] [ require true ]
     * @param  array $includes 包含的staffIds [ require true ]
     * @param  array $excludes 排除的staffIds [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function createStaffGroup (string $groupName, array $rules = [], array $excludes = [], array $includes = []) {
        return self::getClass()->createStaffGroup([
            "groupName" => $groupName,
            "rules" => $rules,
            "excludes" => $excludes,
            "includes" => $includes,
        ]);
    }

    /**
     * rules || includes || excludes 不传则删除原有
     *
     * @param  int $groupId 用户组ID [Original type uint] [ require true ]
     * @param  string $groupName 用户组名称 [ require true ]
     * @param  array $rules 规则组[[&#039;department_id&#039; =&gt; &#039;&#039;, &#039;job_id&#039; =&gt; &#039;&#039;, &#039;level&#039; =&gt; &#039;&#039;]] [ require true ]
     * @param  array $includes 包含的staffIds [ require true ]
     * @param  array $excludes 排除的staffIds [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editStaffGroup (int $groupId, string $groupName, array $rules = [], array $excludes = [], array $includes = []) {
        return self::getClass()->editStaffGroup([
            "groupId" => $groupId,
            "groupName" => $groupName,
            "rules" => $rules,
            "excludes" => $excludes,
            "includes" => $includes,
        ]);
    }

    /**
     * 用户组删除
     *
     * @param  int $groupId 用户组ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteStaffGroup (int $groupId) {
        return self::getClass()->deleteStaffGroup([
            "groupId" => $groupId,
        ]);
    }

    /**
     * 用户组-获取所有用户组基础信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroups () {
        return self::getClass()->getGroups();
    }

    /**
     * 用户组-获取单个用户组信息
     *
     * @param  int $groupId 用户组ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroup (int $groupId) {
        return self::getClass()->getGroup([
            "groupId" => $groupId,
        ]);
    }

    /**
     * 通过用户组规则获取对应的用户信息
     *
     * @param  array $rules 规则组[[&#039;department_id&#039; =&gt; &#039;&#039;, &#039;job_id&#039; =&gt; &#039;&#039;, &#039;level&#039; =&gt; &#039;&#039;]] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffIdsByGroupRules (array $rules) {
        return self::getClass()->getStaffIdsByGroupRules([
            "rules" => $rules,
        ]);
    }

    /**
     * 通过用户ids获取详情
     *
     * @param  array $staffIds staffIds [Original type array&lt;uint&gt;] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffsByStaffIds (array $staffIds) {
        return self::getClass()->getStaffsByStaffIds([
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'Manage\Staff\StaffGroup');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'Manage\Staff\StaffGroup');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}