<?php
namespace Mainto\Bridge\Invokes\TrainingProject\User\DingTalk;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addCollectionByParams(array $params)
 * @method deleteCollectionByParams(array $params)
 * @method getCollectionListByParams(array $params)
 */
class Collection {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新增收藏
     *
     * @param  int $courseId 课程id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function addCollection (int $courseId) {
        return self::getClass()->addCollection([
            "courseId" => $courseId,
        ]);
    }

    /**
     * 取消收藏
     *
     * @param  int $courseId 课程id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function deleteCollection (int $courseId) {
        return self::getClass()->deleteCollection([
            "courseId" => $courseId,
        ]);
    }

    /**
     * 获取收藏列表
     *
     * @support  string $courseName 课程名称 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCollectionList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getCollectionList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'User\DingTalk\Collection');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'User\DingTalk\Collection');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}