<?php
namespace Mainto\Bridge\Invokes\TrainingProject\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method checkTaskNameActiveByParams(array $params)
 * @method addTaskByParams(array $params)
 * @method editTaskByParams(array $params)
 * @method deleteTaskByParams(array $params)
 * @method getTaskListByParams(array $params)
 * @method getTasksByParams(array $params)
 * @method getTaskByParams(array $params)
 * @method getUpyunSignByParams(array $params)
 */
class Task {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 检测任务名称可用
     *
     * @param  string $name 任务名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkTaskNameActive (string $name) {
        return self::getClass()->checkTaskNameActive([
            "name" => $name,
        ]);
    }

    /**
     * 创建任务
     *
     * @param  string $name 名称 [ require true ]
     * @param  string $type 类型 [ require true ]
     * @param  string $contentType 内容 [ require true ]
     * @param  string $demand 任务要求 [ require true ]
     * @param  array $questionItem 题目 [ require true ]
     * @support  array $groupIds 用户组ids 
     * @support  int $canRefresh 是否可刷新 [Original type uint] 
     * @support  int $needScore 是否需评分 [Original type uint] 
     * @support  int $timeLimit 限时 [Original type uint] 
     * @support  int $passScore 合格分 [Original type uint] 
     * @support  int $courseId 课程id [Original type uint] 
     * @support  int $examCount 考试次数 [Original type uint] 
     * @support  array $scoreItem 评分项 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addTask (string $name, string $type, string $contentType, string $demand, array $questionItem) {
        return self::getClass()->addTask([
            "name" => $name,
            "type" => $type,
            "contentType" => $contentType,
            "demand" => $demand,
            "questionItem" => $questionItem,
        ]);
    }

    /**
     * 修改任务
     *
     * @param  int $taskId id [Original type uint] [ require true ]
     * @support  string $name 名称 
     * @support  string $demand 任务要求 
     * @support  array $questionItem 题目 
     * @support  array $groupIds 用户组ids 
     * @support  int $timeLimit 限时 [Original type uint] 
     * @support  int $courseId 课程id [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editTask (int $taskId) {
        return self::getClass()->editTask([
            "taskId" => $taskId,
        ]);
    }

    /**
     * 删除任务
     *
     * @param  int $taskId id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteTask (int $taskId) {
        return self::getClass()->deleteTask([
            "taskId" => $taskId,
        ]);
    }

    /**
     * RpcAuthority(need=&quot;manage.230.task.manage.list&quot;)
     *
     * @support  string $name 名称 
     * @support  string $type 类型 
     * @support  string $contentType 内容 
     * @support  int $needScore 是否需评分 [Original type uint] 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTaskList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getTaskList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 列表.全部
     *
     * @param  string $type 类型, practice 为练习，assessment 为考核 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTasks (string $type) {
        return self::getClass()->getTasks([
            "type" => $type,
        ]);
    }

    /**
     * 详情
     *
     * @param  int $taskId taskId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTask (int $taskId) {
        return self::getClass()->getTask([
            "taskId" => $taskId,
        ]);
    }

    /**
     * 获取又拍云签名
     *
     * @param  string $upyunKey upyun_key [ require true ]
     * @param  bool $isDown isDown [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUpyunSign (string $upyunKey, bool $isDown = false) {
        return self::getClass()->getUpyunSign([
            "upyunKey" => $upyunKey,
            "isDown" => $isDown,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'Manage\Task');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'Manage\Task');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}