<?php
namespace Mainto\Bridge\Invokes\TrainingProject\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getListByPageByParams(array $params)
 * @method addCourseByParams(array $params)
 * @method editCourseByParams(array $params)
 * @method getCourseByIdByParams(array $params)
 * @method deleteCourseByParams(array $params)
 * @method onlineCourseByParams(array $params)
 * @method getCourseListByStaffAndPageByParams(array $params)
 * @method getCourseByStaffByParams(array $params)
 * @method getCourseListByCourseAndPageByParams(array $params)
 */
class Course {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * RpcAuthority(need=&quot;manage.230.task.manage.edit&quot;)
     *
     * @param  string $name 名称 [ require true ]
     * @support  string $studyType 学习类型，compulsory，not_compulsory 
     * @support  int $categoryId 课程分类id 
     * @support  string $status 状态，online,offline 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListByPage (string $name, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getListByPage([
            "name" => $name,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * RpcAuthority(need=&quot;manage.230.task.manage.edit&quot;)
     *
     * @support  string $name 名称 [ require true ]
     * @support  string $description 课程简介 
     * @support  string $studyType 学习类型，compulsory，not_compulsory [ require true ]
     * @support  int $categoryId 课程分类id [ require true ]
     * @support  int $teacherId 讲师id [ require true ]
     * @support  string $coverPicture 封面图地址 
     * @support  int $appraiseStandardId 评价标准id [ require true ]
     * @support  string $type 课件资料类型，normal,video,audio [ require true ]
     * @support  array $metaInfo 学习资料 
     * @support  array $questionItems 小节题内容 待波特定义 [ require true ]
     * @support  string $document 文档内容 
     * @support  bool $isWatermark 是否打水印 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addCourse () {
        return self::getClass()->addCourse();
    }

    /**
     * RpcAuthority(need=&quot;manage.230.task.manage.edit&quot;)
     *
     * @support  int $id id [Original type uint] [ require true ]
     * @support  string $name 名称 [ require true ]
     * @support  string $description 课程简介 
     * @support  string $studyType 学习类型，compulsory，not_compulsory [ require true ]
     * @support  int $categoryId 课程分类id [ require true ]
     * @support  int $teacherId 讲师id [ require true ]
     * @support  string $coverPicture 封面图地址 
     * @support  int $appraiseStandardId 评价标准id [ require true ]
     * @support  string $type 课件资料类型，normal,video,audio [ require true ]
     * @support  array $metaInfo 学习资料 
     * @support  array $questionItems 小节题内容 待波特定义 [ require true ]
     * @support  string $document 文档内容 
     * @support  bool $isWatermark 是否打水印 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editCourse () {
        return self::getClass()->editCourse();
    }

    /**
     * RpcAuthority(need=&quot;manage.230.task.manage.edit&quot;)
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCourseById (int $id) {
        return self::getClass()->getCourseById([
            "id" => $id,
        ]);
    }

    /**
     * RpcAuthority(need=&quot;manage.230.task.manage.edit&quot;)
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteCourse (int $id) {
        return self::getClass()->deleteCourse([
            "id" => $id,
        ]);
    }

    /**
     * RpcAuthority(need=&quot;manage.230.task.manage.edit&quot;)
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @param  string $status 状态，offline, online [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function onlineCourse (int $id, string $status) {
        return self::getClass()->onlineCourse([
            "id" => $id,
            "status" => $status,
        ]);
    }

    /**
     * RpcAuthority(need=&quot;manage.230.task.manage.edit&quot;)
     *
     * @support  int $deptId 部门id 
     * @support  int $groupId 用户组id 
     * @support  string $staff 姓名/花名/工号 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCourseListByStaffAndPage (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getCourseListByStaffAndPage([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * RpcAuthority(need=&quot;manage.230.task.manage.edit&quot;)
     *
     * @param  int $staffId 工号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCourseByStaff (int $staffId) {
        return self::getClass()->getCourseByStaff([
            "staffId" => $staffId,
        ]);
    }

    /**
     * RpcAuthority(need=&quot;manage.230.task.manage.edit&quot;)
     *
     * @support  string $name 课程标题 
     * @support  string $studyType 学习类型，compulsory，not_compulsory 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCourseListByCourseAndPage (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getCourseListByCourseAndPage([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'Manage\Course');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'Manage\Course');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}