<?php
namespace Mainto\Bridge\Invokes\TrainingProject\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getListByPageByParams(array $params)
 * @method addCoursePlanByParams(array $params)
 * @method editCoursePlanByParams(array $params)
 * @method deleteCoursePlanByParams(array $params)
 * @method getCourseIdsByPlanIdByParams(array $params)
 * @method getCourseSchedulesInJsonByPlanIdByParams(array $params)
 * @method existCoursePlanNameAndGroupIdsByParams(array $params)
 */
class CoursePlan {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 学习计划.分页列表
     *
     * @support  string $name 学习计划名称 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListByPage (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getListByPage([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 学习计划.新增
     *
     * @support  string $name 学习计划名称 [ require true ]
     * @support  array $groupIds 用户组 
     * @support  array $schedules 学习计划组集合 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addCoursePlan () {
        return self::getClass()->addCoursePlan();
    }

    /**
     * 学习计划.编辑
     *
     * @support  int $id 计划id [Original type uint] [ require true ]
     * @support  string $name 学习计划名称 [ require true ]
     * @support  array $groupIds 用户组 
     * @support  array $schedules 学习计划组集合 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editCoursePlan () {
        return self::getClass()->editCoursePlan();
    }

    /**
     * 学习计划.删除
     *
     * @support  int $id 计划id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteCoursePlan () {
        return self::getClass()->deleteCoursePlan();
    }

    /**
     * 学习计划.获取课程id数组
     *
     * @param  int $id 学习计划id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCourseIdsByPlanId (int $id) {
        return self::getClass()->getCourseIdsByPlanId([
            "id" => $id,
        ]);
    }

    /**
     * 学习计划.获取有结构的课程id数据
     *
     * @param  int $id 学习计划id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCourseSchedulesInJsonByPlanId (int $id) {
        return self::getClass()->getCourseSchedulesInJsonByPlanId([
            "id" => $id,
        ]);
    }

    /**
     * 学习计划.判断学习计划名称
     *
     * @param  string $name 学习计划名称 [ require true ]
     * @param  array $groupIds 用户组id数组 [ require true ]
     * @param  int $id 用户组id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function existCoursePlanNameAndGroupIds (string $name, array $groupIds, int $id = NULL) {
        return self::getClass()->existCoursePlanNameAndGroupIds([
            "name" => $name,
            "groupIds" => $groupIds,
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'Manage\CoursePlan');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'Manage\CoursePlan');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}