<?php
namespace Mainto\Bridge\Invokes\TrainingProject\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStaffTasksByParams(array $params)
 * @method getRecordListsByParams(array $params)
 * @method getAssessmentStatsByParams(array $params)
 * @method getPracticeStatsByParams(array $params)
 */
class Statistics {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获得用户任务列表
     *
     * @support  string $type 查询类型，assessment 为考核，practice 为练习 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffTasks () {
        return self::getClass()->getStaffTasks();
    }

    /**
     * 获取任务记录列表数据
     *
     * @support  array $taskIds 任务id数组 [Original type array&lt;uint&gt;] 
     * @support  string $scoreBeginTime 评分开始时间 
     * @support  string $scoreEndTime 评分结束时间 
     * @support  string $submitBeginTime 提交开始时间 
     * @support  string $submitEndTime 提交结束时间 
     * @support  bool $isOvertime 是否超时 
     * @support  bool $isPass 是否通过 
     * @support  string $type 查询类型，assessment 为考核，practice 为练习 [ require true ]
     * @param  int $page page [Original type uint] [ require true ]
     * @param  int $pageSize page_size [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRecordLists (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getRecordLists([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获得考核统计
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getAssessmentStats () {
        return self::getClass()->getAssessmentStats();
    }

    /**
     * 获得练习统计
     *
     * @support  string $scoreBeginTime 评分开始时间 
     * @support  string $scoreEndTime 评分结束时间 
     * @support  string $submitBeginTime 提交开始时间 
     * @support  string $submitEndTime 提交结束时间 
     * @throws  \Exception
     * @return  array
     */
    public static function getPracticeStats () {
        return self::getClass()->getPracticeStats();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'User\Statistics');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'User\Statistics');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}