<?php
namespace Mainto\Bridge\Invokes\TrainingProject\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPracticeTaskListByParams(array $params)
 * @method getAssessmentTaskListByParams(array $params)
 * @method getTaskByParams(array $params)
 */
class Task {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 练习列表
     *
     * @support  string $name 名称 
     * @support  string $recordType new最新练习\old最近参与 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPracticeTaskList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getPracticeTaskList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 考核列表
     *
     * @support  string $name 名称 
     * @support  string $recordType new最新练习\old最近参与 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAssessmentTaskList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getAssessmentTaskList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 详情
     *
     * @param  int $taskId task_id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTask (int $taskId) {
        return self::getClass()->getTask([
            "taskId" => $taskId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'User\Task');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'User\Task');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}