<?php
namespace Mainto\Bridge\Invokes\TrainingProject\Manage\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getLevelAllByParams(array $params)
 * @method getJobAllByParams(array $params)
 * @method departmentTreeByParams(array $params)
 * @method storeTreeByParams(array $params)
 * @method syncAddDepartmentByParams(array $params)
 * @method syncEditDepartmentByParams(array $params)
 * @method syncDeleteDepartmentByParams(array $params)
 */
class Department {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 职级列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getLevelAll () {
        return self::getClass()->getLevelAll();
    }

    /**
     * 所有职位
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getJobAll () {
        return self::getClass()->getJobAll();
    }

    /**
     * 部门树结构
     *
     * @throws  \Exception
     * @return  array
     */
    public static function departmentTree () {
        return self::getClass()->departmentTree();
    }

    /**
     * 部门树结构-海马体门店
     *
     * @throws  \Exception
     * @return  array
     */
    public static function storeTree () {
        return self::getClass()->storeTree();
    }

    /**
     * 架构添加监听
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncAddDepartment () {
        return self::getClass()->syncAddDepartment();
    }

    /**
     * 架构修改监听
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncEditDepartment () {
        return self::getClass()->syncEditDepartment();
    }

    /**
     * 架构修改监听
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncDeleteDepartment () {
        return self::getClass()->syncDeleteDepartment();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'Manage\Staff\Department');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'Manage\Staff\Department');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}