<?php
namespace Mainto\Bridge\Invokes\TrainingProject\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPracticeListByParams(array $params)
 * @method getAssessmentListByParams(array $params)
 * @method getExaminationRecordByParams(array $params)
 * @method passByParams(array $params)
 * @method rejectByParams(array $params)
 * @method waitAnswerNotifyByParams(array $params)
 */
class ExaminationRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 分页获取练习记录列表
     *
     * @param  int $taskId 任务id [Original type uint] [ require true ]
     * @support  string $name 员工姓名 
     * @support  array $status 状态 
     * @support  string $submitAtBegin 提交时间开始 
     * @support  string $submitAtEnd 提交时间结束 
     * @support  array $departmentIds 部门ids 
     * @param  int $page page [Original type uint] [ require true ]
     * @param  int $pageSize page_size [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPracticeList (int $taskId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getPracticeList([
            "taskId" => $taskId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 分页获取练习考核记录列表
     *
     * @param  int $taskId 任务id [Original type uint] [ require true ]
     * @support  string $name 员工姓名 
     * @support  array $status 状态 
     * @support  string $submitAtBegin 提交时间开始 
     * @support  string $submitAtEnd 提交时间结束 
     * @support  array $departmentIds 部门ids 
     * @param  int $page page [Original type uint] [ require true ]
     * @param  int $pageSize page_size [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAssessmentList (int $taskId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getAssessmentList([
            "taskId" => $taskId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取练习考核记录详情
     *
     * @param  int $recordId 记录id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getExaminationRecord (int $recordId) {
        return self::getClass()->getExaminationRecord([
            "recordId" => $recordId,
        ]);
    }

    /**
     * 评分通过
     *
     * @param  int $recordId 记录id [Original type uint] [ require true ]
     * @param  array $reviewItem 评分详情 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function pass (int $recordId, array $reviewItem) {
        return self::getClass()->pass([
            "recordId" => $recordId,
            "reviewItem" => $reviewItem,
        ]);
    }

    /**
     * 评分退回
     *
     * @param  int $recordId 记录id [Original type uint] [ require true ]
     * @param  array $reviewItem 评分详情 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reject (int $recordId, array $reviewItem) {
        return self::getClass()->reject([
            "recordId" => $recordId,
            "reviewItem" => $reviewItem,
        ]);
    }

    /**
     * 提醒答题通知
     *
     * @param  int $staffId 工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function waitAnswerNotify (int $staffId) {
        return self::getClass()->waitAnswerNotify([
            "staffId" => $staffId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'Manage\ExaminationRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'Manage\ExaminationRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}