<?php
namespace Mainto\Bridge\Invokes\TrainingProject\Manage\RBAC;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAdminListByParams(array $params)
 * @method addAdminByParams(array $params)
 * @method updateAdminByParams(array $params)
 * @method deleteAdminByParams(array $params)
 * @method onStaffDeletedByParams(array $params)
 * @method getPermissionsByParams(array $params)
 * @method loginDetailByParams(array $params)
 */
class Admin {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 管理员列表
     *
     * @param  array $staffIds 工号组 [Original type array&lt;uint&gt;] [ require true ]
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAdminList (array $staffIds = [], int $page = 1, int $pageSize = 10) {
        return self::getClass()->getAdminList([
            "staffIds" => $staffIds,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 管理员新增
     *
     * @param  int $staffId 工号 [Original type uint] [ require true ]
     * @param  array $permissionIds 权限组 [Original type array&lt;uint&gt;] [ require true ]
     * @param  array $departmentPermissions 部门ids [ require true ]
     * @param  array $storePermissions 新人管理门店ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addAdmin (int $staffId, array $permissionIds = [], array $departmentPermissions = [], array $storePermissions = []) {
        return self::getClass()->addAdmin([
            "staffId" => $staffId,
            "permissionIds" => $permissionIds,
            "departmentPermissions" => $departmentPermissions,
            "storePermissions" => $storePermissions,
        ]);
    }

    /**
     * 管理员更新
     *
     * @param  int $staffId 工号 [Original type uint] [ require true ]
     * @param  array $permissionIds 权限组 [Original type array&lt;uint&gt;] [ require true ]
     * @param  array $departmentPermissions 部门ids [ require true ]
     * @param  array $storePermissions 新人管理门店ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateAdmin (int $staffId, array $permissionIds = [], array $departmentPermissions = [], array $storePermissions = []) {
        return self::getClass()->updateAdmin([
            "staffId" => $staffId,
            "permissionIds" => $permissionIds,
            "departmentPermissions" => $departmentPermissions,
            "storePermissions" => $storePermissions,
        ]);
    }

    /**
     * 管理员删除
     *
     * @param  int $staffId 工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteAdmin (int $staffId) {
        return self::getClass()->deleteAdmin([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 通过 hook 执行这儿的伙伴移除， 集群网关触发默认执行，需要有这儿的功能保留
     *
     * @param  int $staffId 伙伴id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function onStaffDeleted (int $staffId) {
        return self::getClass()->onStaffDeleted([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 获取单个管理员拥有的所有权限
     *
     * @param  int $staffId 工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPermissions (int $staffId) {
        return self::getClass()->getPermissions([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 管理员登录个人和权限信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function loginDetail () {
        return self::getClass()->loginDetail();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'Manage\RBAC\Admin');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'Manage\RBAC\Admin');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}