<?php
namespace Mainto\Bridge\Invokes\TrainingProject\Manage\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStaffGroupListByParams(array $params)
 * @method getStaffWithDepartmentsByParams(array $params)
 * @method getLevelWithPositionsByParams(array $params)
 * @method createStaffGroupByParams(array $params)
 * @method updateStaffGroupByParams(array $params)
 * @method deleteStaffGroupByParams(array $params)
 * @method getStaffGroupByParams(array $params)
 * @method getGroupNameAndStaffIdsByParams(array $params)
 */
class StaffGroup {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用户组列表查询
     *
     * @param  string $groupName 用户组名称 [ require true ]
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffGroupList (int $page, int $pageSize, string $groupName = '') {
        return self::getClass()->getStaffGroupList([
            "page" => $page,
            "pageSize" => $pageSize,
            "groupName" => $groupName,
        ]);
    }

    /**
     * 查询伙伴.按组织架构
     *
     * @param  array $deptIds 部门ids数组 [Original type array&lt;uint&gt;] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffWithDepartments (array $deptIds) {
        return self::getClass()->getStaffWithDepartments([
            "deptIds" => $deptIds,
        ]);
    }

    /**
     * 查询职级.按职位
     *
     * @param  array $jobIds 职位ids数组 [Original type array&lt;uint&gt;] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getLevelWithPositions (array $jobIds) {
        return self::getClass()->getLevelWithPositions([
            "jobIds" => $jobIds,
        ]);
    }

    /**
     * RpcAuthority(need=&quot;manage.230.staff.group.manage&quot;)
     *
     * @param  string $groupName 用户组名称 [ require true ]
     * @param  array $groupTypes 正常值有两个[dep[], jobWithLevel[]]，如果按组织架构传递，使用dep[]；如果按职级传递，使用jobWithLevel[]；注意只有部门下员工全选才将值添加到dep[]，如果非全选，将伙伴按staffId添加到extraStaff [ require true ]
     * @param  array $extraStaff staffIds，配合dep[]使用，如果按组织架构选择，且部门人员非全选到化，那将值添加到这儿 [Original type array&lt;uint&gt;] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createStaffGroup (string $groupName, array $groupTypes, array $extraStaff = []) {
        return self::getClass()->createStaffGroup([
            "groupName" => $groupName,
            "groupTypes" => $groupTypes,
            "extraStaff" => $extraStaff,
        ]);
    }

    /**
     * 用户组更新
     *
     * @param  int $groupId 用户组ID [Original type uint] [ require true ]
     * @param  string $groupName 用户组名称 [ require true ]
     * @param  array $groupTypes 正常值有两个[dep[], jobWithLevel[]]，如果按组织架构传递，使用dep[]；如果按职级传递，使用jobWithLevel[]；注意只有部门下员工全选才将值添加到dep[]，如果非全选，将伙伴按staffId添加到extraStaff [ require true ]
     * @param  array $extraStaff staffIds，配合dep[]使用，如果按组织架构选择，且部门人员非全选到化，那将值添加到这儿 [Original type array&lt;uint&gt;] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateStaffGroup (int $groupId, string $groupName, array $groupTypes, array $extraStaff = []) {
        return self::getClass()->updateStaffGroup([
            "groupId" => $groupId,
            "groupName" => $groupName,
            "groupTypes" => $groupTypes,
            "extraStaff" => $extraStaff,
        ]);
    }

    /**
     * 用户组删除
     *
     * @param  int $groupId 用户组ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteStaffGroup (int $groupId) {
        return self::getClass()->deleteStaffGroup([
            "groupId" => $groupId,
        ]);
    }

    /**
     * 用户组-获取单个用户组信息
     *
     * @param  int $groupId 用户组ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffGroup (int $groupId) {
        return self::getClass()->getStaffGroup([
            "groupId" => $groupId,
        ]);
    }

    /**
     * 查询组名和伙伴总数
     *
     * @param  array $groupIds 用户组id集合，结构如：[1,2,3,4,5,6,7]，不传就是获取全部用户组数据 [Original type array&lt;uint&gt;] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroupNameAndStaffIds (array $groupIds = []) {
        return self::getClass()->getGroupNameAndStaffIds([
            "groupIds" => $groupIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'Manage\Staff\StaffGroup');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'Manage\Staff\StaffGroup');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}