<?php
namespace Mainto\Bridge\Invokes\TrainingProject\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addQuestionByParams(array $params)
 * @method deleteQuestionByParams(array $params)
 * @method getQuestionsByQuestionBankIdByParams(array $params)
 */
class Question {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建题目
     *
     * @param  int $question_bank_id 题库id [Original type uint] [ require true ]
     * @param  string $type 题目类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addQuestion (int $question_bank_id, string $type = 'photo') {
        return self::getClass()->addQuestion([
            "question_bank_id" => $question_bank_id,
            "type" => $type,
        ]);
    }

    /**
     * 删除题目
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteQuestion (int $id) {
        return self::getClass()->deleteQuestion([
            "id" => $id,
        ]);
    }

    /**
     * 根据题库id获取题目
     *
     * @param  int $question_bank_id 题库id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getQuestionsByQuestionBankId (int $question_bank_id) {
        return self::getClass()->getQuestionsByQuestionBankId([
            "question_bank_id" => $question_bank_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'Manage\Question');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'Manage\Question');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}