<?php
namespace Mainto\Bridge\Invokes\TrainingProject\Manage\RBAC;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAdminListByParams(array $params)
 * @method addAdminByParams(array $params)
 * @method updateAdminByParams(array $params)
 * @method deleteAdminByParams(array $params)
 * @method onStaffDeletedByParams(array $params)
 * @method getPermissionsByParams(array $params)
 */
class Admin {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 管理员列表
     *
     * @param  array $staff_ids 工号组 [ require true ]
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $page_size 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAdminList (array $staff_ids = [], int $page = 1, int $page_size = 10) {
        return self::getClass()->getAdminList([
            "staff_ids" => $staff_ids,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 管理员新增
     *
     * @param  int $staff_id 工号 [Original type uint] [ require true ]
     * @param  array $permission_ids 权限组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addAdmin (int $staff_id, array $permission_ids = []) {
        return self::getClass()->addAdmin([
            "staff_id" => $staff_id,
            "permission_ids" => $permission_ids,
        ]);
    }

    /**
     * 管理员更新
     *
     * @param  int $staff_id 工号 [Original type uint] [ require true ]
     * @param  array $permission_ids 权限组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateAdmin (int $staff_id, array $permission_ids = []) {
        return self::getClass()->updateAdmin([
            "staff_id" => $staff_id,
            "permission_ids" => $permission_ids,
        ]);
    }

    /**
     * 管理员删除
     *
     * @param  int $staff_id 工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteAdmin (int $staff_id) {
        return self::getClass()->deleteAdmin([
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * 通过 hook 执行这儿的伙伴移除， 集群网关触发默认执行，需要有这儿的功能保留
     *
     * @param  int $staff_id 伙伴id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function onStaffDeleted (int $staff_id) {
        return self::getClass()->onStaffDeleted([
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * 获取单个管理员拥有的所有权限
     *
     * @param  int $staff_id 工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPermissions (int $staff_id) {
        return self::getClass()->getPermissions([
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'Manage\RBAC\Admin');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'Manage\RBAC\Admin');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}