<?php
namespace Mainto\Bridge\Invokes\TrainingProject\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method checkTaskNameActiveByParams(array $params)
 * @method addTaskByParams(array $params)
 * @method editTaskByParams(array $params)
 * @method deleteTaskByParams(array $params)
 * @method getTaskListByParams(array $params)
 * @method getTaskByParams(array $params)
 * @method getUpyunSignByParams(array $params)
 */
class Task {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 检测任务名称可用
     *
     * @param  string $name 任务名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkTaskNameActive (string $name) {
        return self::getClass()->checkTaskNameActive([
            "name" => $name,
        ]);
    }

    /**
     * 创建
     *
     * @param  string $name 名称 [ require true ]
     * @param  string $type 类型 [ require true ]
     * @param  string $content 内容 [ require true ]
     * @param  string $demand 任务要求 [ require true ]
     * @param  array $question_item 题目 [ require true ]
     * @support  array $group_ids 用户组ids 
     * @support  int $can_refresh 是否可刷新 [Original type uint] 
     * @support  int $need_score 是否需评分 [Original type uint] 
     * @support  int $time_limit 限时 [Original type uint] 
     * @support  array $score_item 评分项 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addTask (string $name, string $type, string $content, string $demand, array $question_item) {
        return self::getClass()->addTask([
            "name" => $name,
            "type" => $type,
            "content" => $content,
            "demand" => $demand,
            "question_item" => $question_item,
        ]);
    }

    /**
     * 修改
     *
     * @param  int $task_id id [Original type uint] [ require true ]
     * @support  string $name 名称 
     * @support  string $demand 任务要求 
     * @support  array $question_item 题目 
     * @support  array $group_ids 用户组ids 
     * @support  int $time_limit 限时 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editTask (int $task_id) {
        return self::getClass()->editTask([
            "task_id" => $task_id,
        ]);
    }

    /**
     * 删除
     *
     * @param  int $task_id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteTask (int $task_id) {
        return self::getClass()->deleteTask([
            "task_id" => $task_id,
        ]);
    }

    /**
     * 列表
     *
     * @support  string $name 名称 
     * @support  string $type 类型 
     * @support  string $content 内容 
     * @support  int $need_score 是否需评分 [Original type uint] 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $page_size 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTaskList (int $page = 1, int $page_size = 10) {
        return self::getClass()->getTaskList([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 详情
     *
     * @param  int $task_id task_id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTask (int $task_id) {
        return self::getClass()->getTask([
            "task_id" => $task_id,
        ]);
    }

    /**
     * 获取又拍云签名
     *
     * @param  string $upyun_key upyun_key [ require true ]
     * @support  bool $isDown isDown 
     * @throws  \Exception
     * @return  array
     */
    public static function getUpyunSign (string $upyun_key) {
        return self::getClass()->getUpyunSign([
            "upyun_key" => $upyun_key,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'Manage\Task');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'Manage\Task');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}