<?php
namespace Mainto\Bridge\Invokes\TrainingProject\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getExaminationRecordByParams(array $params)
 * @method getExaminationRecordsByParams(array $params)
 * @method beginExamByParams(array $params)
 * @method refreshByParams(array $params)
 * @method submitByParams(array $params)
 * @method getUpyunSignByParams(array $params)
 */
class ExaminationRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取练习考核记录详情
     *
     * @param  int $recordId 记录id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getExaminationRecord (int $recordId) {
        return self::getClass()->getExaminationRecord([
            "recordId" => $recordId,
        ]);
    }

    /**
     * 获取练习考核记录列表
     *
     * @param  int $taskId 任务id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getExaminationRecords (int $taskId) {
        return self::getClass()->getExaminationRecords([
            "taskId" => $taskId,
        ]);
    }

    /**
     * 开始练习/考核
     *
     * @param  int $taskId 任务id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function beginExam (int $taskId) {
        return self::getClass()->beginExam([
            "taskId" => $taskId,
        ]);
    }

    /**
     * 刷新题目
     *
     * @param  int $recordId 记录id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function refresh (int $recordId) {
        return self::getClass()->refresh([
            "recordId" => $recordId,
        ]);
    }

    /**
     * 提交练习/考核数据
     *
     * @param  int $recordId 记录id [Original type uint] [ require true ]
     * @param  array $submitItem 评分详情 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submit (int $recordId, array $submitItem) {
        return self::getClass()->submit([
            "recordId" => $recordId,
            "submitItem" => $submitItem,
        ]);
    }

    /**
     * 获取又拍云签名
     *
     * @param  string $upyunKey upyunKey [ require true ]
     * @param  bool $isDown isDown [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUpyunSign (string $upyunKey, bool $isDown = false) {
        return self::getClass()->getUpyunSign([
            "upyunKey" => $upyunKey,
            "isDown" => $isDown,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'User\ExaminationRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'User\ExaminationRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}