<?php
namespace Mainto\Bridge\Invokes\TrainingProject\Manage\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStaffGroupListByParams(array $params)
 * @method getStaffWithDepartmentsByParams(array $params)
 * @method getLevelWithPositionsByParams(array $params)
 * @method createStaffGroupByParams(array $params)
 * @method updateStaffGroupByParams(array $params)
 * @method deleteStaffGroupByParams(array $params)
 * @method getStaffGroupByParams(array $params)
 * @method getGroupNameAndStaffIdsByParams(array $params)
 */
class StaffGroup {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用户组列表查询
     *
     * @param  string $group_name 用户组名称 [ require true ]
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $page_size 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffGroupList (int $page, int $page_size, string $group_name = '') {
        return self::getClass()->getStaffGroupList([
            "page" => $page,
            "page_size" => $page_size,
            "group_name" => $group_name,
        ]);
    }

    /**
     * 查询伙伴.按组织架构
     *
     * @param  array $dept_ids 部门ids数组 [Original type array&lt;uint&gt;] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffWithDepartments (array $dept_ids) {
        return self::getClass()->getStaffWithDepartments([
            "dept_ids" => $dept_ids,
        ]);
    }

    /**
     * 查询职级.按职位
     *
     * @param  array $job_ids 职位ids数组 [Original type array&lt;uint&gt;] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getLevelWithPositions (array $job_ids) {
        return self::getClass()->getLevelWithPositions([
            "job_ids" => $job_ids,
        ]);
    }

    /**
     * 用户组新增
     *
     * @param  string $group_name 用户组名称 [ require true ]
     * @param  array $group_types 正常值有两个[dep[], job_with_level[]]，如果按组织架构传递，使用dep[]；如果按职级传递，使用job_with_level[]；注意只有部门下员工全选才将值添加到dep[]，如果非全选，将伙伴按staff_id添加到extra_staff [ require true ]
     * @param  array $extra_staff staffIds，配合dep[]使用，如果按组织架构选择，且部门人员非全选到化，那将值添加到这儿 [Original type array&lt;uint&gt;] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createStaffGroup (string $group_name, array $group_types, array $extra_staff = []) {
        return self::getClass()->createStaffGroup([
            "group_name" => $group_name,
            "group_types" => $group_types,
            "extra_staff" => $extra_staff,
        ]);
    }

    /**
     * 用户组更新
     *
     * @param  int $group_id 用户组ID [Original type uint] [ require true ]
     * @param  string $group_name 用户组名称 [ require true ]
     * @param  array $group_types 正常值有两个[dep[], job_with_level[]]，如果按组织架构传递，使用dep[]；如果按职级传递，使用job_with_level[]；注意只有部门下员工全选才将值添加到dep[]，如果非全选，将伙伴按staff_id添加到extra_staff [ require true ]
     * @param  array $extra_staff staffIds，配合dep[]使用，如果按组织架构选择，且部门人员非全选到化，那将值添加到这儿 [Original type array&lt;uint&gt;] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateStaffGroup (int $group_id, string $group_name, array $group_types, array $extra_staff = []) {
        return self::getClass()->updateStaffGroup([
            "group_id" => $group_id,
            "group_name" => $group_name,
            "group_types" => $group_types,
            "extra_staff" => $extra_staff,
        ]);
    }

    /**
     * 用户组删除
     *
     * @param  int $group_id 用户组ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteStaffGroup (int $group_id) {
        return self::getClass()->deleteStaffGroup([
            "group_id" => $group_id,
        ]);
    }

    /**
     * 用户组-获取单个用户组信息
     *
     * @param  int $group_id 用户组ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffGroup (int $group_id) {
        return self::getClass()->getStaffGroup([
            "group_id" => $group_id,
        ]);
    }

    /**
     * 查询组名和伙伴总数
     *
     * @param  array $group_ids 用户组id集合，结构如：[1,2,3,4,5,6,7] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroupNameAndStaffIds (array $group_ids) {
        return self::getClass()->getGroupNameAndStaffIds([
            "group_ids" => $group_ids,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'Manage\Staff\StaffGroup');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'Manage\Staff\StaffGroup');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}