<?php
namespace Mainto\Bridge\Invokes\ThirdProduct\WeChatVideoProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\ThirdProduct\WeChatVideoProduct\Cmd\CreateCmd $params)
 * @method listByParams(array|\Mainto\Bridge\Structs\ThirdProduct\WeChatVideoProduct\Cmd\SearchCmd $params)
 * @method detailByParams(array $params)
 * @method upByParams(array $params)
 * @method offByParams(array $params)
 * @method deleteByParams(array $params)
 */
class WeChatVideoProduct {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新增产品
     *
     * @var  \Mainto\Bridge\Structs\ThirdProduct\WeChatVideoProduct\Cmd\CreateCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ThirdProduct\WeChatVideoProduct\DTO\WeChatVideoProductDTO
     */
    public static function create (\Mainto\Bridge\Structs\ThirdProduct\WeChatVideoProduct\Cmd\CreateCmd $cmd) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->create($cmd),
            "\Mainto\Bridge\Structs\ThirdProduct\WeChatVideoProduct\DTO\WeChatVideoProductDTO"
        );
    }


    /**
     * 产品列表
     *
     * @var  \Mainto\Bridge\Structs\ThirdProduct\WeChatVideoProduct\Cmd\SearchCmd $searchCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ThirdProduct\WeChatVideoProduct\DTO\ListDTO
     */
    public static function list (\Mainto\Bridge\Structs\ThirdProduct\WeChatVideoProduct\Cmd\SearchCmd $searchCmd) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->list($searchCmd),
            "\Mainto\Bridge\Structs\ThirdProduct\WeChatVideoProduct\DTO\ListDTO"
        );
    }


    /**
     * 查询产品详情
     *
     * @param  int $id 微信直播产品ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ThirdProduct\WeChatVideoProduct\DTO\WeChatVideoProductDTO
     */
    public static function detail (int $id) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->detail([
                            "id" => $id,
                        ]),
            "\Mainto\Bridge\Structs\ThirdProduct\WeChatVideoProduct\DTO\WeChatVideoProductDTO"
        );
    }

    /**
     * 上架产品
     *
     * @param  int $id 微信直播产品ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function up (int $id) {
        return self::getClass()->up([
            "id" => $id,
        ]);
    }

    /**
     * 下架产品
     *
     * @param  int $id 微信直播产品ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function off (int $id) {
        return self::getClass()->off([
            "id" => $id,
        ]);
    }

    /**
     * 删除产品
     *
     * @param  int $id 微信直播产品ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ThirdProduct', 'WeChatVideoProduct\WeChatVideoProduct');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ThirdProduct', 'WeChatVideoProduct\WeChatVideoProduct');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}