<?php
namespace Mainto\Bridge\Invokes\Test\Example;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method dbByParams(array $params)
 * @method cacheByParams(array $params)
 * @method benchmarkByParams(array $params)
 */
class Query {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * query with db
     *
     * @throws  \Exception
     * @return  array
     */
    public static function db () {
        return self::getClass()->db();
    }

    /**
     * query with cache
     *
     * @throws  \Exception
     * @return  string
     */
    public static function cache () {
        return self::getClass()->cache();
    }

    /**
     * query with cache
     *
     * @throws  \Exception
     * @return  string
     */
    public static function benchmark () {
        return self::getClass()->benchmark();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Test', 'Example\Query');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Test', 'Example\Query');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}