<?php
namespace Mainto\Bridge\Invokes\Test;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method sayHelloByParams(array $params)
 * @method printLogByParams(array $params)
 * @method sayHelloValidationByParams(array $params)
 * @method sayHelloWithAuthByParams(array $params)
 * @method sayHelloWithManyParamsByParams(array $params)
 * @method sayObjectByParams(array|\Mainto\Bridge\Structs\Test\Cmd\SayObjectCmd $params)
 * @method getHostnameByParams(array $params)
 * @method getImageByParams(array $params)
 * @method errorExampleByParams(array $params)
 * @method errorExampleSpecialByParams(array $params)
 * @method settingByParams(array $params)
 * @method objectRequestByParams(array|\Mainto\Bridge\Structs\Test\Cmd\ObjectRequestCmd $params)
 * @method getCronLogByParams(array $params)
 * @method noLockTestByParams(array $params)
 * @method lockTestByParams(array $params)
 * @method remoteNotFoundByParams(array $params)
 * @method rcpLogPushByParams(array $params)
 * @method remoteCallTestByParams(array $params)
 * @method remoteCallTestWithObjectByParams(array $params)
 * @method getRequestIpByParams(array $params)
 * @method visitByParams(array $params)
 * @method usleepByParams(array $params)
 * @method sleepByParams(array $params)
 * @method addMessageByParams(array $params)
 * @method addQueueMessageByParams(array $params)
 * @method getMessageQueueLogByParams(array $params)
 * @method helloJavaByParams(array $params)
 */
class Example {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * say hello to client with no auth
     * more doc
     *
     * @support  string $name 返回的姓名 [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function sayHello () {
        return self::getClass()->sayHello([
        ]);
    }

    /**
     * printLog
     *
     * @throws  \Exception
     * @return  string
     */
    public static function printLog () {
        return self::getClass()->printLog();
    }

    /**
     * sayHello.validation
     *
     * @support  string $name 返回的姓名 [ require false ]
     * @support  mixed $hobby 爱好 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function sayHelloValidation () {
        return self::getClass()->sayHelloValidation([
        ]);
    }

    /**
     * say hello to client with auth
     * RpcAuthority: 做管理端权限校验, 接口请求头中有x-stream-id的处理
     *
     * @param  string $name 返回的姓名 [ require false ]
     * @param  int $age 当我在函数的请求参数加上$age时，它是必填的, 和 require=true 效果是一样的 [ require true ]
     * @support  string $sex 可以不在函数的请求参数上添加 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function sayHelloWithAuth (int $age, string $name = 'world') {
        return self::getClass()->sayHelloWithAuth([
            "age" => $age,
            "name" => $name,
        ]);
    }

    /**
     * sayHelloWithManyParams
     *
     * @param  string $name 返回的姓名 [ require false ]
     * @param  int $age 当我在函数的请求参数加上$age时，它是必填的, 和 require=true 效果是一样的 [ require false ]
     * @param  string $sex 可以不在函数的请求参数上添加 [ require true ]
     * @param  mixed $hobby 混合属性，即不校验属性类型, 但通常不推荐使用 [ require true ]
     * @param  int $staffId 从session中获取数据 [ require true ]
     * @param  string $realIp 从header中获取数据 [ require false ]
     * @throws  \Exception
     * @return  Mainto\RpcServer\Util\Types\Map
     */
    public static function sayHelloWithManyParams (string $sex, $hobby, int $staffId, int $age = 18, string $realIp = '', string $name = 'world') {
        return self::getClass()->sayHelloWithManyParams([
            "sex" => $sex,
            "hobby" => $hobby,
            "staffId" => $staffId,
            "age" => $age,
            "realIp" => $realIp,
            "name" => $name,
        ]);
    }

    /**
     * Cmd 不能和 RpcParam 一起使用
     *
     * @var  \Mainto\Bridge\Structs\Test\Cmd\SayObjectCmd $hello
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Test\DTO\SayObjectDTO
     */
    public static function sayObject (\Mainto\Bridge\Structs\Test\Cmd\SayObjectCmd $hello) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->sayObject($hello),
            "\Mainto\Bridge\Structs\Test\DTO\SayObjectDTO"
        );
    }


    /**
     * 获取主机名
     *
     * @param  bool $isRpcHostname is_rpc_hostname [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function getHostname (bool $isRpcHostname = true) {
        return self::getClass()->getHostname([
            "isRpcHostname" => $isRpcHostname,
        ]);
    }

    /**
     * 获取图片
     *
     * @throws  \Exception
     * @return  string
     */
    public static function getImage () {
        return self::getClass()->getImage();
    }

    /**
     * 如果你设置了这儿的RpcSupportEnv值，那么这个接口会直接不加载到etcd中去，所以慎重使用
     * test error
     *
     * @throws  \Exception
     * @return  void
     */
    public static function errorExample () {
        return self::getClass()->errorExample();
    }

    /**
     * 按指定的错误码返回，错误码需要提前定义，而且是所有项目 所有项目不能重复
     *
     * @throws  \Exception
     * @return  void
     */
    public static function errorExampleSpecial () {
        return self::getClass()->errorExampleSpecial();
    }

    /**
     * 这个setting为本地使用，上线统一使用配置中心
     *
     * @throws  \Exception
     * @return  string
     */
    public static function setting () {
        return self::getClass()->setting();
    }

    /**
     * 主要是几种基础类型的示例，和嵌套object,嵌套map,map嵌套map的示例
     *
     * @var  \Mainto\Bridge\Structs\Test\Cmd\ObjectRequestCmd $objectRequest
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Test\DTO\ObjectRequestDTO
     */
    public static function objectRequest (\Mainto\Bridge\Structs\Test\Cmd\ObjectRequestCmd $objectRequest) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->objectRequest($objectRequest),
            "\Mainto\Bridge\Structs\Test\DTO\ObjectRequestDTO"
        );
    }


    /**
     * 需要和CrontabController中的 Cache::put() 配合起来使用，基础缓存也是这么使用的
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getCronLog () {
        return self::getClass()->getCronLog();
    }

    /**
     * 并发的部分，通过接口调用实现，不在这儿实现
     *
     * @throws  \Exception
     * @return  int
     */
    public static function noLockTest () {
        return self::getClass()->noLockTest();
    }

    /**
     * 并发的部分，通过接口调用实现，不在这儿实现; 这儿举例了锁的使用
     *
     * @throws  \Exception
     * @return  int
     */
    public static function lockTest () {
        return self::getClass()->lockTest();
    }

    /**
     * 服务不存在
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function remoteNotFound () {
        return self::getClass()->remoteNotFound();
    }

    /**
     * 日志推送
     *
     * @throws  \Exception
     * @return  array
     */
    public static function rcpLogPush () {
        return self::getClass()->rcpLogPush();
    }

    /**
     * 远程调用示例
     *
     * @throws  \Exception
     * @return  int
     */
    public static function remoteCallTest () {
        return self::getClass()->remoteCallTest();
    }

    /**
     * 如果底层的函数接收参数部分定义的就是对象，那在这儿可以直接使用对象做入参使用;
     *
     * @throws  \Exception
     * @return  array
     */
    public static function remoteCallTestWithObject () {
        return self::getClass()->remoteCallTestWithObject();
    }

    /**
     * X-Real-Ip
     * 获得真实用户ip,
     *
     * @throws  \Exception
     * @return  string
     */
    public static function getRequestIp () {
        return self::getClass()->getRequestIp();
    }

    /**
     * Session使用示例
     * 在RpcSession中有好多的方法使用，但正常只会用到get方法
     *
     * @throws  \Exception
     * @return  int
     */
    public static function visit () {
        return self::getClass()->visit();
    }

    /**
     * usleep
     *
     * @param  int $time 等待时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function usleep (int $time = 10000) {
        return self::getClass()->usleep([
            "time" => $time,
        ]);
    }

    /**
     * sleep
     *
     * @param  int $time 等待时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sleep (int $time = 10) {
        return self::getClass()->sleep([
            "time" => $time,
        ]);
    }

    /**
     * 消息推送
     * 老版消息推送，现已被新版 RpcQueue做了替换
     *
     * @support  int $delay 延迟时间（可以不传） [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function addMessage () {
        return self::getClass()->addMessage([
        ]);
    }

    /**
     * 消息推送
     *
     * @support  int $delay 延迟时间（可以不传） [ require false ]
     * @support  string $topic topic [ require false ]
     * @support  string $content content [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function addQueueMessage () {
        return self::getClass()->addQueueMessage([
        ]);
    }

    /**
     * 获得消息推送日志
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMessageQueueLog () {
        return self::getClass()->getMessageQueueLog();
    }

    /**
     * helloJava
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function helloJava () {
        return self::getClass()->helloJava();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Test', 'Example');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Test', 'Example');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}