<?php
namespace Mainto\Bridge\Invokes\Test\Example;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method messageTestByParams(array $params)
 * @method messageTest2ByParams(array $params)
 * @method messageTest6ByParams(array $params)
 * @method messageTestNewByParams(array $params)
 */
class Hook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 消息测试
     * 老版消息推送，延迟推送.1
     *
     * @support  int $delay 延迟时间（可以不传） [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function messageTest () {
        return self::getClass()->messageTest([
        ]);
    }

    /**
     * 消息测试
     * 老版消息推送，延迟推送.2
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function messageTest2 () {
        return self::getClass()->messageTest2();
    }

    /**
     * 消息测试
     * 老版消息推送，立即推送
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function messageTest6 () {
        return self::getClass()->messageTest6();
    }

    /**
     * 新版消息推送，
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function messageTestNew () {
        return self::getClass()->messageTestNew();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Test', 'Example\Hook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Test', 'Example\Hook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}