<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2022-08-16 16:49:15
 */
namespace Mainto\Bridge\Invokes\Test\Example;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Rpc
 */
class Rpc {
    private static string $serviceName = "Test";

    private static string $className = "Example\\Rpc";

    /**
     * 服务不存在
     *
     */
    public static function remoteNotFound () {
        return RpcClass::getClass(self::$serviceName, self::$className)->remoteNotFound();
    }
    /**
     * 日志推送
     *
     */
    public static function rcpLogPush (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->rcpLogPush();
    }
    /**
     * 远程调用示例
     *
     */
    public static function remoteCallTest (): int {
        return RpcClass::getClass(self::$serviceName, self::$className)->remoteCallTest();
    }
    /**
     * 远程调用示例,通过object调用
     *
     */
    public static function remoteCallTestWithObject (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->remoteCallTestWithObject();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    mixed
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}