<?php
namespace Mainto\Bridge\Structs\Test\MvcTest;

class UpdateMessageParams {
    /**
     * @var  int
     * comment: 消息内容
     */
    public int $messageId;
    /**
     * @var  string
     * comment: 消息内容
     */
    public string $content;
    /**
     * @var  string
     * comment: 消息内容
     */
    public string $type;
    /**
     * @var  array
     * comment: 扩展信息
     */
    public array $extend;

    public function __construct (int $messageId) {
        $this->messageId = $messageId;
    }

    public static function create(int $messageId): self {
        return new self($messageId);
    }

    public function setMessageId(int $messageId): self {
        $this->messageId = $messageId;

        return $this;
    }

    public function setContent(string $content): self {
        $this->content = $content;

        return $this;
    }

    public function setType(string $type): self {
        $this->type = $type;

        return $this;
    }

    public function setExtend(array $extend): self {
        $this->extend = $extend;

        return $this;
    }
}