<?php
namespace Mainto\Bridge\Structs\Test\Example;

class SayHelloWithManyParamsParams {
    /**
     * @var  string
     * comment: 返回的姓名
     */
    public string $name = "world";
    /**
     * @var  int
     * comment: 当我在函数的请求参数加上$age时，它是必填的, 和 require=true 效果是一样的
     */
    public int $age = 18;
    /**
     * @var  string
     * comment: 可以不在函数的请求参数上添加
     */
    public string $sex;
    /**
     * @var  null|mixed
     * comment: 混合属性，即不校验属性类型, 但通常不推荐使用
     */
    public ?mixed $hobby;
    /**
     * @var  int
     * comment: 从session中获取数据
     */
    public int $staffId;
    /**
     * @var  string
     * comment: 从header中获取数据
     */
    public string $realIp = "";

    public function __construct (string $sex, ?mixed $hobby, int $staffId) {
        $this->sex = $sex;
        $this->hobby = $hobby;
        $this->staffId = $staffId;
    }

    public static function create(string $sex, ?mixed $hobby, int $staffId): self {
        return new self($sex, $hobby, $staffId);
    }

    public function setName(string $name): self {
        $this->name = $name;

        return $this;
    }

    public function setAge(int $age): self {
        $this->age = $age;

        return $this;
    }

    public function setSex(string $sex): self {
        $this->sex = $sex;

        return $this;
    }

    public function setHobby(?mixed $hobby): self {
        $this->hobby = $hobby;

        return $this;
    }

    public function setStaffId(int $staffId): self {
        $this->staffId = $staffId;

        return $this;
    }

    public function setRealIp(string $realIp): self {
        $this->realIp = $realIp;

        return $this;
    }
}