<?php
namespace Mainto\Bridge\Structs\Test\Example;

class SayHelloWithAuthParams {
    /**
     * @var  string
     * comment: 返回的姓名
     */
    public string $name = "world";
    /**
     * @var  int
     * comment: 当我在函数的请求参数加上$age时，它是必填的, 和 require=true 效果是一样的
     */
    public int $age;
    /**
     * @var  string
     * comment: 可以不在函数的请求参数上添加
     */
    public string $sex;

    public function __construct (int $age, string $sex) {
        $this->age = $age;
        $this->sex = $sex;
    }

    public static function create(int $age, string $sex): self {
        return new self($age, $sex);
    }

    public function setName(string $name): self {
        $this->name = $name;

        return $this;
    }

    public function setAge(int $age): self {
        $this->age = $age;

        return $this;
    }

    public function setSex(string $sex): self {
        $this->sex = $sex;

        return $this;
    }
}