<?php
namespace Mainto\Bridge\Invokes\Test;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class MvcTest
 */
class MvcTest {
    private static string $serviceName = "Test";

    private static string $className = "MvcTest";

    /**
     * 获取消息列表
     *
     */
    public static function messageList (\Mainto\Bridge\Structs\Test\MvcTest\MessageListParams $messageListParams) {
        return RpcClass::getClass(self::$serviceName, self::$className)->messageList($messageListParams);
    }
    /**
     * 获取消息详情
     *
     */
    public static function getMessageDetail (\Mainto\Bridge\Structs\Test\MvcTest\GetMessageDetailParams $getMessageDetailParams) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMessageDetail($getMessageDetailParams);
    }
    /**
     * 添加消息
     *
     */
    public static function addMessage (\Mainto\Bridge\Structs\Test\MvcTest\AddMessageParams $addMessageParams) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addMessage($addMessageParams);
    }
    /**
     * 更新消息
     *
     */
    public static function updateMessage (\Mainto\Bridge\Structs\Test\MvcTest\UpdateMessageParams $updateMessageParams) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateMessage($updateMessageParams);
    }
    /**
     * 删除消息
     *
     */
    public static function deleteMessage (\Mainto\Bridge\Structs\Test\MvcTest\DeleteMessageParams $deleteMessageParams) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteMessage($deleteMessageParams);
    }
    /**
     * 获取服务器时间
     *
     */
    public static function getServerTime () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getServerTime();
    }
}