<?php
namespace Mainto\Bridge\Invokes\Test\Example;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Rpc
 */
class Rpc {
    private static string $serviceName = "Test";

    private static string $className = "Example\\Rpc";

    /**
     * 服务不存在
     *
     */
    public static function remoteNotFound () {
        return RpcClass::getClass(self::$serviceName, self::$className)->remoteNotFound();
    }
    /**
     * 日志推送
     *
     */
    public static function rcpLogPush () {
        return RpcClass::getClass(self::$serviceName, self::$className)->rcpLogPush();
    }
    /**
     * 远程调用示例
     *
     */
    public static function remoteCallTest () {
        return RpcClass::getClass(self::$serviceName, self::$className)->remoteCallTest();
    }
    /**
     * 远程调用示例.通过object调用
     *
     */
    public static function remoteCallTestWithObject () {
        return RpcClass::getClass(self::$serviceName, self::$className)->remoteCallTestWithObject();
    }
}