<?php
namespace Mainto\Bridge\Structs\Test\MvcTest;

class AddMessageParams {
    /**
     * @var  string
     * comment: 消息内容
     * rpc type: string
     */
    public string $content;
    /**
     * @var  string
     * comment: 消息内容
     * rpc type: string
     */
    public string $type;
    /**
     * @var  array
     * comment: 扩展信息
     * rpc type: mixed[]
     */
    public array $extend;

    public function __construct (string $content) {
        $this->content = $content;
    }

    public static function create(string $content): self {
        return new self($content, );
    }

    public AddMessageParams setContent(string content) {
        $this->content = content;

        return $this;
    }

    public AddMessageParams setType(string type) {
        $this->type = type;

        return $this;
    }

    public AddMessageParams setExtend(array extend) {
        $this->extend = extend;

        return $this;
    }
}