<?php
namespace Mainto\Bridge\Structs\Test\MvcTest;

class UpdateMessageParams {
    /**
     * @var  int
     * comment: 消息内容
     * rpc type: int
     */
    public int $messageId;
    /**
     * @var  string
     * comment: 消息内容
     * rpc type: string
     */
    public string $content;
    /**
     * @var  string
     * comment: 消息内容
     * rpc type: string
     */
    public string $type;
    /**
     * @var  array
     * comment: 扩展信息
     * rpc type: mixed[]
     */
    public array $extend;

    public function __construct (int $messageId) {
        $this->messageId = $messageId;
    }

    public static function create(int $messageId): self {
        return new self($messageId, );
    }

    public UpdateMessageParams setMessageId(int messageId) {
        $this->messageId = messageId;

        return $this;
    }

    public UpdateMessageParams setContent(string content) {
        $this->content = content;

        return $this;
    }

    public UpdateMessageParams setType(string type) {
        $this->type = type;

        return $this;
    }

    public UpdateMessageParams setExtend(array extend) {
        $this->extend = extend;

        return $this;
    }
}