<?php
namespace Mainto\Bridge\Structs\Test\Example;

class SayHelloWithManyParamsParams {
    /**
     * @var  string
     * comment: 返回的姓名
     * rpc type: string
     */
    public string $name = "world";
    /**
     * @var  int
     * comment: 当我在函数的请求参数加上$age时，它是必填的, 和 require=true 效果是一样的
     * rpc type: int
     */
    public int $age = 18;
    /**
     * @var  string
     * comment: 可以不在函数的请求参数上添加
     * rpc type: string
     */
    public string $sex;
    /**
     * @var  null|mixed
     * comment: 混合属性，即不校验属性类型, 但通常不推荐使用
     * rpc type: mixed
     */
    public ?mixed $hobby;
    /**
     * @var  int
     * comment: 从session中获取数据
     * rpc type: int
     */
    public int $staffId;
    /**
     * @var  string
     * comment: 从header中获取数据
     * rpc type: string
     */
    public string $realIp = "";

    public function __construct (string $sex, ?mixed $hobby, int $staffId) {
        $this->sex = $sex;
        $this->hobby = $hobby;
        $this->staffId = $staffId;
    }

    public static function create(string $sex, ?mixed $hobby, int $staffId): self {
        return new self($sex, $hobby, $staffId, );
    }

    public SayHelloWithManyParamsParams setName(string name) {
        $this->name = name;

        return $this;
    }

    public SayHelloWithManyParamsParams setAge(int age) {
        $this->age = age;

        return $this;
    }

    public SayHelloWithManyParamsParams setSex(string sex) {
        $this->sex = sex;

        return $this;
    }

    public SayHelloWithManyParamsParams setHobby(?mixed hobby) {
        $this->hobby = hobby;

        return $this;
    }

    public SayHelloWithManyParamsParams setStaffId(int staffId) {
        $this->staffId = staffId;

        return $this;
    }

    public SayHelloWithManyParamsParams setRealIp(string realIp) {
        $this->realIp = realIp;

        return $this;
    }
}