<?php
namespace Mainto\Bridge\Structs\Test\Cmd;

class SayObjectCmd {
    /**
     * @var  string
     * comment: 姓名
     * rpc type: string
     */
    public string $name;
    /**
     * @var  int
     * comment: 年龄
     * rpc type: int
     */
    public int $age = 0;
    /**
     * @var  string
     * comment: 使用和RpcParam的效果是一样的, 但是没有default
     * rpc type: string
     */
    public string $sex;

    public function __construct (string $name, string $sex) {
        $this->name = $name;
        $this->sex = $sex;
    }

    public static function create(string $name, string $sex): self {
        return new self($name, $sex, );
    }

    public SayObjectCmd setName(string name) {
        $this->name = name;

        return $this;
    }

    public SayObjectCmd setAge(int age) {
        $this->age = age;

        return $this;
    }

    public SayObjectCmd setSex(string sex) {
        $this->sex = sex;

        return $this;
    }
}