<?php
namespace Mainto\Bridge\Invokes\Test;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Example
 */
class Example {
    private static string $serviceName = "Test";

    private static string $className = "Example";

    /**
     * sayHello
     *
     */
    public static function sayHello (\Mainto\Bridge\Structs\Test\Example\SayHelloParams $sayHelloParams) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sayHello($sayHelloParams);
    }
    /**
     * sayHello.validation
     *
     */
    public static function sayHelloValidation (\Mainto\Bridge\Structs\Test\Example\SayHelloValidationParams $sayHelloValidationParams) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sayHelloValidation($sayHelloValidationParams);
    }
    /**
     * sayHelloWithAuth
     *
     */
    public static function sayHelloWithAuth (\Mainto\Bridge\Structs\Test\Example\SayHelloWithAuthParams $sayHelloWithAuthParams) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sayHelloWithAuth($sayHelloWithAuthParams);
    }
    /**
     * sayHelloWithManyParams
     *
     */
    public static function sayHelloWithManyParams (\Mainto\Bridge\Structs\Test\Example\SayHelloWithManyParamsParams $sayHelloWithManyParamsParams) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sayHelloWithManyParams($sayHelloWithManyParamsParams);
    }
    /**
     * sayObject
     *
     */
    public static function sayObject (\Mainto\Bridge\Structs\Test\Cmd\SayObjectCmd $sayObjectCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sayObject($sayObjectCmd);
    }
    /**
     * 获取主机名
     *
     */
    public static function getHostname (\Mainto\Bridge\Structs\Test\Example\GetHostnameParams $getHostnameParams) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getHostname($getHostnameParams);
    }
    /**
     * 获取服务命名空间
     *
     */
    public static function getNamespace () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getNamespace();
    }
    /**
     * 获取图片
     *
     */
    public static function getImage () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getImage();
    }
    /**
     * 返回错误码未提前定义的错误
     *
     */
    public static function errorExample () {
        return RpcClass::getClass(self::$serviceName, self::$className)->errorExample();
    }
    /**
     * 返回错误码提前定义的错误
     *
     */
    public static function errorExampleSpecial () {
        return RpcClass::getClass(self::$serviceName, self::$className)->errorExampleSpecial();
    }
    /**
     * setting
     *
     */
    public static function setting () {
        return RpcClass::getClass(self::$serviceName, self::$className)->setting();
    }
    /**
     * object request
     *
     */
    public static function objectRequest (\Mainto\Bridge\Structs\Test\Cmd\ObjectRequestCmd $objectRequestCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->objectRequest($objectRequestCmd);
    }
    /**
     * 无锁并发测试
     *
     */
    public static function noLockTest () {
        return RpcClass::getClass(self::$serviceName, self::$className)->noLockTest();
    }
    /**
     * 有锁并发测试
     *
     */
    public static function lockTest () {
        return RpcClass::getClass(self::$serviceName, self::$className)->lockTest();
    }
    /**
     * getRequestIp
     *
     */
    public static function getRequestIp () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRequestIp();
    }
    /**
     * visit
     *
     */
    public static function visit () {
        return RpcClass::getClass(self::$serviceName, self::$className)->visit();
    }
    /**
     * usleep
     *
     */
    public static function usleep (\Mainto\Bridge\Structs\Test\Example\UsleepParams $usleepParams) {
        return RpcClass::getClass(self::$serviceName, self::$className)->usleep($usleepParams);
    }
    /**
     * sleep
     *
     */
    public static function sleep (\Mainto\Bridge\Structs\Test\Example\SleepParams $sleepParams) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sleep($sleepParams);
    }
    /**
     * helloJava
     *
     */
    public static function helloJava () {
        return RpcClass::getClass(self::$serviceName, self::$className)->helloJava();
    }
    /**
     * helloJavaFromSdk
     *
     */
    public static function helloJavaFromSdk () {
        return RpcClass::getClass(self::$serviceName, self::$className)->helloJavaFromSdk();
    }
    /**
     * exampleException
     *
     */
    public static function exampleException () {
        return RpcClass::getClass(self::$serviceName, self::$className)->exampleException();
    }
    /**
     * notReportExampleException
     *
     */
    public static function notReportExampleException () {
        return RpcClass::getClass(self::$serviceName, self::$className)->notReportExampleException();
    }
    /**
     * exampleExceptionBodyArray
     *
     */
    public static function exampleExceptionBodyArray () {
        return RpcClass::getClass(self::$serviceName, self::$className)->exampleExceptionBodyArray();
    }
    /**
     * innerRpcMethod
     *
     */
    public static function innerRpcMethod (\Mainto\Bridge\Structs\Test\Example\InnerRpcMethodParams $innerRpcMethodParams) {
        return RpcClass::getClass(self::$serviceName, self::$className)->innerRpcMethod($innerRpcMethodParams);
    }
}