<?php
namespace Mainto\Bridge\Invokes\Test\Example;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method sayHelloByParams(array $params)
 * @method cronTest2ByParams(array $params)
 * @method cronTest3ByParams(array $params)
 * @method getCronLogByParams(array $params)
 * @method inputUserInfoByParams(array $params)
 * @method fileDownloadByParams(array $params)
 * @method noLockTestByParams(array $params)
 * @method lockTestByParams(array $params)
 * @method visitByParams(array $params)
 * @method addMessageByParams(array $params)
 * @method messageTestByParams(array $params)
 * @method messageTest2ByParams(array $params)
 * @method getMessageQueueLogByParams(array $params)
 * @method chatPollByParams(array $params)
 */
class Example {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * say hello to client
     * more doc
     * more doc
     *
     * @param  string $name 返回的姓名 [ require true ]
     * @param  array $array array [ require true ]
     * @param  bool $bool bool [ require true ]
     * @param  int $zero zero [ require true ]
     * @support  int $null null [ require true ]
     * @support  string $validation 验证 [ require true ]
     * @support  string $useless 无用参数 
     * @throws  \Exception
     * @return  string
     */
    public static function sayHello (string $name = 'world', array $array = [], bool $bool = false, int $zero = 0) {
        return self::getClass()->sayHello([
            "name" => $name,
            "array" => $array,
            "bool" => $bool,
            "zero" => $zero,
        ]);
    }

    /**
     * cronTest2
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronTest2 () {
        return self::getClass()->cronTest2();
    }

    /**
     * cronTest3
     * @deprecated
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronTest3 () {
        return self::getClass()->cronTest3();
    }

    /**
     * 获得定时任务执行日志
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCronLog () {
        return self::getClass()->getCronLog();
    }

    /**
     * stream input by client
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function inputUserInfo () {
        return self::getClass()->inputUserInfo();
    }

    /**
     * 下载文件
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function fileDownload () {
        return self::getClass()->fileDownload();
    }

    /**
     * 无锁并发测试
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function noLockTest () {
        return self::getClass()->noLockTest();
    }

    /**
     * 有锁并发测试
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function lockTest () {
        return self::getClass()->lockTest();
    }

    /**
     * Session使用示例
     *
     * @throws  \Exception
     * @return  int
     */
    public static function visit () {
        return self::getClass()->visit();
    }

    /**
     * 消息推送
     *
     * @support  int $delay 延迟时间（可以不传） [Original type uint] 
     * @throws  \Exception
     * @return  string
     */
    public static function addMessage () {
        return self::getClass()->addMessage();
    }

    /**
     * 消息测试
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function messageTest () {
        return self::getClass()->messageTest();
    }

    /**
     * 消息测试
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function messageTest2 () {
        return self::getClass()->messageTest2();
    }

    /**
     * 获得消息推送日志
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getMessageQueueLog () {
        return self::getClass()->getMessageQueueLog();
    }

    /**
     * 简易聊天室
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function chatPoll () {
        return self::getClass()->chatPoll();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Test', 'Example\Example');
    }

    /**
     * getMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function getMock () {
        return RpcClass::registerMockClass('Test', 'Example\Example');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}