<?php
namespace Mainto\Bridge\Invokes\Test\Example;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method sayHelloByParams(array $params)
 * @method sayObjectByParams(array $params)
 * @method getHostnameByParams(array $params)
 * @method sleepByParams(array $params)
 * @method postByParams(array $params)
 * @method errorExampleByParams(array $params)
 * @method settingByParams(array $params)
 * @method cronTestByParams(array $params)
 * @method cronTest2ByParams(array $params)
 * @method cronTest3ByParams(array $params)
 * @method objectRequestByParams(array $params)
 * @method getCronLogByParams(array $params)
 * @method noLockTestByParams(array $params)
 * @method remoteNotFoundByParams(array $params)
 * @method rcpLogPushByParams(array $params)
 * @method lockTestByParams(array $params)
 * @method remoteCallTestByParams(array $params)
 * @method getRequestIpByParams(array $params)
 * @method visitByParams(array $params)
 * @method addMessageByParams(array $params)
 * @method messageTestByParams(array $params)
 * @method messageTest2ByParams(array $params)
 * @method getMessageQueueLogByParams(array $params)
 * @method chatPollByParams(array $params)
 */
class Example {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * say hello to client
     * more doc
     * more doc
     *
     * @param  string $name 返回的姓名 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function sayHello (string $name = 'world') {
        return self::getClass()->sayHello([
            "name" => $name,
        ]);
    }

    /**
     * say hello to client
     * more doc
     * more doc
     *
     * @support  string $name  [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function sayObject (\App\Rpc\Objects\SayHello $hello) {
        return self::getClass()->sayObject([
            "hello" => $hello,
        ]);
    }

    /**
     * 获取主机名
     *
     * @param  bool $isRpcHostname is_rpc_hostname [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getHostname (bool $isRpcHostname = true) {
        return self::getClass()->getHostname([
            "isRpcHostname" => $isRpcHostname,
        ]);
    }

    /**
     * sleep
     *
     * @param  uint $time 等待时间 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function sleep (int $time = 10000) {
        return self::getClass()->sleep([
            "time" => $time,
        ]);
    }

    /**
     * post
     *
     * @param  string $post 等待时间 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function post (string $post) {
        return self::getClass()->post([
            "post" => $post,
        ]);
    }

    /**
     * test error
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function errorExample () {
        return self::getClass()->errorExample();
    }

    /**
     * test error
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function setting () {
        return self::getClass()->setting();
    }

    /**
     * cronTest
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronTest () {
        return self::getClass()->cronTest();
    }

    /**
     * cronTest2
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronTest2 () {
        return self::getClass()->cronTest2();
    }

    /**
     * cronTest3
     * @deprecated
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronTest3 () {
        return self::getClass()->cronTest3();
    }

    /**
     * objectRequest
     *
     * @support  bool $bool  require false
     * @support  int $int  require false
     * @support  string $string  require false
     * @support  array $arrayString  require false
     * @support  array $arrayInt  require false
     * @support  double $float  require false
     * @support  array $arrayWithDoc  [ require true ]
     * @support  App\Rpc\Objects\ObjectRequest $nestingObject  require false
     * @support  Map&lt;string|int, App\Rpc\Objects\ObjectRequest&gt; $nestingObjectMap  require false
     * @support  Map&lt;string|int, App\Rpc\Objects\ObjectRequest&gt; $mapObjectMap  require false
     * @throws  \Exception
     * @return  \App\Rpc\Objects\ObjectResponse[]
     */
    public static function objectRequest (\App\Rpc\Objects\ObjectRequest $objectRequest) {
        return self::getClass()->objectRequest([
            "objectRequest" => $objectRequest,
        ]);
    }

    /**
     * 获得定时任务执行日志
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCronLog () {
        return self::getClass()->getCronLog();
    }

    /**
     * 无锁并发测试
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function noLockTest () {
        return self::getClass()->noLockTest();
    }

    /**
     * 服务不存在
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function remoteNotFound () {
        return self::getClass()->remoteNotFound();
    }

    /**
     * 日志推送
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function rcpLogPush () {
        return self::getClass()->rcpLogPush();
    }

    /**
     * 有锁并发测试
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function lockTest () {
        return self::getClass()->lockTest();
    }

    /**
     * remote all
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function remoteCallTest () {
        return self::getClass()->remoteCallTest();
    }

    /**
     * X-Real-Ip
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRequestIp () {
        return self::getClass()->getRequestIp();
    }

    /**
     * Session使用示例
     *
     * @throws  \Exception
     * @return  int
     */
    public static function visit () {
        return self::getClass()->visit();
    }

    /**
     * 消息推送
     *
     * @support  uint $delay 延迟时间（可以不传） require false
     * @throws  \Exception
     * @return  string
     */
    public static function addMessage () {
        return self::getClass()->addMessage();
    }

    /**
     * 消息测试
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function messageTest () {
        return self::getClass()->messageTest();
    }

    /**
     * 消息测试
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function messageTest2 () {
        return self::getClass()->messageTest2();
    }

    /**
     * 获得消息推送日志
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getMessageQueueLog () {
        return self::getClass()->getMessageQueueLog();
    }

    /**
     * 简易聊天室
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function chatPoll () {
        return self::getClass()->chatPoll();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Test', 'Example\Example');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Test', 'Example\Example');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}